function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'com/crescentine/trajanstanks/entity/tanks/basetank/BaseTankEntity',
		'methodName': 'removeFuel',
		'methodDesc': '(I)V'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/TrajansTanks$Tank',
		'methodName': 'onFuelBurned',
		'methodDesc': '(Lnet/minecraft/world/entity/Entity;I)V'
	}

	var instructions = [
		insnLoadThis("tank"),
		insnLoadInt(1, "consumed amount"),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}