/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.forge.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import elocindev.item_obliterator.forge.ItemObliterator;
import elocindev.item_obliterator.forge.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class}, priority=199)
public class RecipeDisablingMixin {
    @Inject(at={@At(value="HEAD")}, method={"apply"}, cancellable=true)
    private void item_obliterator$apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        HashMap<ResourceLocation, JsonElement> filteredMap = new HashMap<ResourceLocation, JsonElement>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation ResourceLocation2 = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                boolean shouldDisable;
                block8: {
                    JsonElement resultElement;
                    block9: {
                        block7: {
                            resultElement = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"top element").get("result");
                            if (resultElement == null) {
                                filteredMap.put(ResourceLocation2, jsonElement);
                                continue;
                            }
                            shouldDisable = false;
                            if (!resultElement.isJsonObject()) break block7;
                            JsonObject resultObject = resultElement.getAsJsonObject();
                            String itemId = GsonHelper.m_13906_((JsonObject)resultObject, (String)"item");
                            if (itemId == null || !Utils.shouldRecipeBeDisabled(itemId)) break block8;
                            shouldDisable = true;
                            break block8;
                        }
                        if (!resultElement.isJsonPrimitive() || !resultElement.getAsJsonPrimitive().isString()) break block9;
                        String itemId = resultElement.getAsString();
                        if (itemId == null || !Utils.shouldRecipeBeDisabled(itemId)) break block8;
                        shouldDisable = true;
                        break block8;
                    }
                    if (resultElement.isJsonArray()) {
                        JsonArray resultArray = resultElement.getAsJsonArray();
                        for (JsonElement element : resultArray) {
                            String itemId;
                            if (element.isJsonObject()) {
                                JsonObject resultObject = element.getAsJsonObject();
                                String itemId2 = GsonHelper.m_13906_((JsonObject)resultObject, (String)"item");
                                if (itemId2 == null || !Utils.shouldRecipeBeDisabled(itemId2)) continue;
                                shouldDisable = true;
                                break;
                            }
                            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString() || (itemId = element.getAsString()) == null || !Utils.shouldRecipeBeDisabled(itemId)) continue;
                            shouldDisable = true;
                            break;
                        }
                    }
                }
                if (shouldDisable) continue;
                filteredMap.put(ResourceLocation2, jsonElement);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                ItemObliterator.LOGGER.debug("Parsing error loading recipe {}", (Object)ResourceLocation2, (Object)e);
                filteredMap.put(ResourceLocation2, jsonElement);
            }
        }
        map.clear();
        map.putAll(filteredMap);
    }
}

