/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import com.mrcrayfish.framework.entity.sync.Updatable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class DataEntry<E extends Entity, T> {
    private final DataHolder holder;
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean dirty;

    DataEntry(@Nullable DataHolder holder, SyncedDataKey<E, T> key) {
        this.holder = holder;
        this.key = key;
        this.value = key.defaultValueSupplier().apply(new Updatable(this));
    }

    SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value, boolean dirty) {
        this.value = value;
        if (dirty) {
            this.markDirty();
        }
    }

    public void markDirty() {
        this.dirty = true;
        if (this.holder != null) {
            this.holder.markDirty();
        }
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
    }

    public void write(FriendlyByteBuf buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.m_130130_(id);
        this.key.serializer().write(buffer, this.value);
    }

    public static DataEntry<?, ?> createClientEntry(FriendlyByteBuf buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.m_130242_());
        Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
        DataEntry entry = new DataEntry(null, key);
        entry.readValue(buffer);
        return entry;
    }

    private void readValue(FriendlyByteBuf buffer) {
        this.value = this.getKey().serializer().read(Updatable.NULL, buffer);
    }

    Tag writeValue() {
        return this.key.serializer().write(this.value);
    }

    void readValue(Tag nbt) {
        this.value = this.key.serializer().read(new Updatable(this), nbt);
    }
}

