/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.event;

import com.mrcrayfish.framework.api.event.FrameworkEvent;
import com.mrcrayfish.framework.event.IPlayerEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class PlayerEvents {
    public static final FrameworkEvent<IPlayerEvent.StartTrackingEntity> START_TRACKING_ENTITY = new FrameworkEvent<IPlayerEvent.StartTrackingEntity>(listeners -> (entity, player) -> listeners.forEach(event -> event.handle(entity, player)));
    public static final FrameworkEvent<IPlayerEvent.EndTrackingEntity> END_TRACKING_ENTITY = new FrameworkEvent<IPlayerEvent.EndTrackingEntity>(listeners -> (entity, player) -> listeners.forEach(event -> event.handle(entity, player)));
    public static final FrameworkEvent<IPlayerEvent.Copy> COPY = new FrameworkEvent<IPlayerEvent.Copy>(listeners -> (oldPlayer, newPlayer, conqueredEnd) -> listeners.forEach(event -> event.handle(oldPlayer, newPlayer, conqueredEnd)));
    public static final FrameworkEvent<IPlayerEvent.ChangeDimension> CHANGE_DIMENSION = new FrameworkEvent<IPlayerEvent.ChangeDimension>(listeners -> (player, oldDimension, newDimension) -> listeners.forEach(event -> event.handle(player, (ResourceKey<Level>)oldDimension, (ResourceKey<Level>)newDimension)));
    public static final FrameworkEvent<IPlayerEvent.Respawn> RESPAWN = new FrameworkEvent<IPlayerEvent.Respawn>(listeners -> (player, finishedGame) -> listeners.forEach(event -> event.handle(player, finishedGame)));
    public static final FrameworkEvent<IPlayerEvent.LoggedIn> LOGGED_IN = new FrameworkEvent<IPlayerEvent.LoggedIn>(listeners -> player -> listeners.forEach(event -> event.handle(player)));
    public static final FrameworkEvent<IPlayerEvent.LoggedOut> LOGGED_OUT = new FrameworkEvent<IPlayerEvent.LoggedOut>(listeners -> player -> listeners.forEach(event -> event.handle(player)));
    public static final FrameworkEvent<IPlayerEvent.PickupItem> PICKUP_ITEM = new FrameworkEvent<IPlayerEvent.PickupItem>(listeners -> (player, itemEntity) -> {
        for (IPlayerEvent.PickupItem listener : listeners) {
            if (!listener.handle(player, itemEntity)) continue;
            return true;
        }
        return false;
    });
    public static final FrameworkEvent<IPlayerEvent.CraftItem> CRAFT_ITEM = new FrameworkEvent<IPlayerEvent.CraftItem>(listeners -> (player, stack, container) -> listeners.forEach(event -> event.handle(player, stack, container)));
    public static final FrameworkEvent<IPlayerEvent.PickupExperience> PICKUP_EXPERIENCE = new FrameworkEvent<IPlayerEvent.PickupExperience>(listeners -> (player, experienceOrb) -> {
        for (IPlayerEvent.PickupExperience listener : listeners) {
            if (!listener.handle(player, experienceOrb)) continue;
            return true;
        }
        return false;
    });
    public static final FrameworkEvent<IPlayerEvent.Death> DEATH = new FrameworkEvent<IPlayerEvent.Death>(listeners -> (player, damageSource) -> {
        for (IPlayerEvent.Death listener : listeners) {
            if (!listener.handle(player, damageSource)) continue;
            return true;
        }
        return false;
    });
}

