/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework;

import com.mrcrayfish.framework.FrameworkData;
import com.mrcrayfish.framework.FrameworkSetup;
import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.IRegisterFunction;
import com.mrcrayfish.framework.client.ClientFrameworkForge;
import com.mrcrayfish.framework.entity.sync.ForgeSyncedEntityDataHandler;
import com.mrcrayfish.framework.event.ForgeEvents;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="framework")
public class FrameworkForge {
    public static final Logger LOGGER = LogManager.getLogger((String)"Framework");

    public FrameworkForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onLoadComplete);
        bus.addListener(this::onRegister);
        bus.addListener(ForgeSyncedEntityDataHandler::registerCapabilities);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::onClientSetup);
            bus.addListener(ClientFrameworkForge::registerKeyMappings);
            bus.addListener(ClientFrameworkForge::registerReloadListener);
        });
        FrameworkSetup.run();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        ModList.get().getModContainerById("framework").ifPresent(container -> {
            String modVersion = container.getModInfo().getVersion().toString();
            ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> modVersion, (remoteVersion, fromServer) -> fromServer != false && (remoteVersion == null || remoteVersion.equals(modVersion))));
        });
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(FrameworkSetup::init);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientFrameworkForge::init);
    }

    private void onRegister(final RegisterEvent event) {
        Registration.get(event.getRegistryKey()).forEach(entry -> entry.register(new IRegisterFunction(){

            @Override
            public <T> void call(Registry<T> registry, ResourceLocation name, Supplier<T> supplier) {
                event.register(registry.m_123023_(), name, supplier);
            }
        }));
        if (event.getRegistryKey().equals((Object)Registry.f_122904_)) {
            Registration.get(Registry.f_122901_).forEach(entry -> {
                if (entry instanceof BlockRegistryEntry) {
                    BlockRegistryEntry blockEntry = (BlockRegistryEntry)entry;
                    blockEntry.item().ifPresent(item -> event.register(Registry.f_122904_, entry.getId(), () -> item));
                }
            });
        }
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        FrameworkData.setLoaded();
    }
}

