/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.worlddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BackpackDataManager
extends SavedData {
    public static HashMap<String, BackpackItemHandler> CLIENT_SIDE_BACKPACKS = new HashMap();
    public static final String NAME = "IFBackpack";
    public static final int SLOT_AMOUNT = 32;
    public HashMap<String, BackpackItemHandler> itemHandlers = new HashMap();

    public BackpackDataManager(String name) {
    }

    public BackpackDataManager() {
    }

    public void createBackPack(UUID uuid) {
        this.itemHandlers.put(uuid.toString(), new BackpackItemHandler(this));
        this.m_77762_();
    }

    public BackpackItemHandler getBackpack(String id) {
        return this.itemHandlers.get(id);
    }

    public static BackpackDataManager load(CompoundTag nbt) {
        BackpackDataManager manager = new BackpackDataManager();
        manager.itemHandlers = new HashMap();
        CompoundTag backpacks = nbt.m_128469_("Backpacks");
        for (String s : backpacks.m_128431_()) {
            BackpackItemHandler hander = new BackpackItemHandler(manager);
            hander.deserializeNBT(backpacks.m_128469_(s));
            manager.itemHandlers.put(s, hander);
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        this.itemHandlers.forEach((s, iItemHandler) -> nbt.m_128365_(s, (Tag)iItemHandler.serializeNBT()));
        compound.m_128365_("Backpacks", (Tag)nbt);
        return compound;
    }

    @Nullable
    public static BackpackDataManager getData(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = ((ServerLevel)world).m_7654_().m_129880_(Level.f_46428_);
            BackpackDataManager data = (BackpackDataManager)serverWorld.m_8895_().m_164861_(BackpackDataManager::load, BackpackDataManager::new, NAME);
            return data;
        }
        return null;
    }

    public static class BackpackItemHandler
    implements IItemHandler,
    INBTSerializable<CompoundTag> {
        private List<SlotDefinition> definitionList = new ArrayList<SlotDefinition>();
        private int maxAmount;
        private BackpackDataManager dataManager;

        public BackpackItemHandler(BackpackDataManager manager) {
            for (int i = 0; i < 32; ++i) {
                this.definitionList.add(new SlotDefinition(this));
            }
            this.maxAmount = 2048;
            this.dataManager = manager;
        }

        public CompoundTag serializeNBT() {
            CompoundTag slots = new CompoundTag();
            for (int i = 0; i < this.definitionList.size(); ++i) {
                slots.m_128365_("" + i, (Tag)this.definitionList.get(i).serializeNBT());
            }
            CompoundTag output = new CompoundTag();
            output.m_128365_("Slots", (Tag)slots);
            output.m_128405_("MaxAmount", this.maxAmount);
            return output;
        }

        public void deserializeNBT(CompoundTag nbt) {
            CompoundTag slots = nbt.m_128469_("Slots");
            for (String s : slots.m_128431_()) {
                this.definitionList.get(Integer.parseInt(s)).deserializeNBT(slots.m_128469_(s));
            }
            this.maxAmount = nbt.m_128451_("MaxAmount");
        }

        public int getSlots() {
            return this.definitionList.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.definitionList.get(slot).getStack(), (int)this.definitionList.get(slot).getAmount());
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                SlotDefinition definition = this.definitionList.get(slot);
                int inserted = Math.min(this.maxAmount - definition.getAmount(), stack.m_41613_());
                if (definition.isVoidItems()) {
                    inserted = stack.m_41613_();
                }
                if (!simulate) {
                    definition.setStack(stack);
                    definition.setAmount(Math.min(definition.getAmount() + inserted, this.maxAmount));
                    this.markDirty();
                }
                if (inserted == stack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted));
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            SlotDefinition definition = this.definitionList.get(slot);
            if (definition.getStack().m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (definition.getAmount() <= amount) {
                ItemStack out = definition.getStack().m_41777_();
                int newAmount = definition.getAmount();
                if (!simulate) {
                    definition.setAmount(0);
                    this.markDirty();
                }
                out.m_41764_(newAmount);
                return out;
            }
            if (!simulate) {
                definition.setAmount(definition.getAmount() - amount);
                this.markDirty();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)definition.getStack(), (int)amount);
        }

        public int getSlotLimit(int slot) {
            return this.maxAmount;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            SlotDefinition def = this.definitionList.get(slot);
            return def.getStack().m_41619_() || def.getStack().m_41656_(stack) && ItemStack.m_41658_((ItemStack)def.getStack(), (ItemStack)stack);
        }

        public void setMaxAmount(int maxAmount) {
            this.maxAmount = maxAmount;
            this.markDirty();
        }

        public void markDirty() {
            if (this.dataManager != null) {
                this.dataManager.m_77762_();
            }
        }

        public SlotDefinition getSlotDefinition(int slot) {
            return this.definitionList.get(slot);
        }
    }

    public static class SlotDefinition
    implements INBTSerializable<CompoundTag> {
        private ItemStack stack = ItemStack.f_41583_;
        private int amount = 0;
        private boolean voidItems = true;
        private boolean refillItems = false;
        private BackpackItemHandler parent;

        public SlotDefinition(BackpackItemHandler parent) {
            this.parent = parent;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.parent.markDirty();
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.parent.markDirty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128365_("Stack", (Tag)this.stack.serializeNBT());
            compoundNBT.m_128405_("Amount", this.amount);
            compoundNBT.m_128379_("Void", this.voidItems);
            compoundNBT.m_128379_("Refill", this.refillItems);
            return compoundNBT;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
            this.amount = nbt.m_128451_("Amount");
            this.voidItems = nbt.m_128471_("Void");
            this.refillItems = nbt.m_128471_("Refill");
        }

        public boolean isVoidItems() {
            return this.voidItems;
        }

        public void setVoidItems(boolean voidItems) {
            this.voidItems = voidItems;
            this.parent.markDirty();
        }

        public boolean isRefillItems() {
            return this.refillItems;
        }

        public void setRefillItems(boolean refillItems) {
            this.refillItems = refillItems;
            this.parent.markDirty();
        }
    }
}

