/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.rewards.rewardparts.BasePart;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.StringVar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandPart
extends BasePart {
    public static Map<Integer, UUID> randUUIDs = new HashMap<Integer, UUID>();
    private final StringVar command;
    private IntVar copies = new IntVar(0);
    private BoolVar copiesSoft = new BoolVar(false);
    private BoolVar relativeToPlayer = new BoolVar(false);

    public CommandPart(String command) {
        this(command, 0);
    }

    public CommandPart(String command, int delay) {
        this(new StringVar(command), new IntVar(delay));
    }

    public CommandPart(StringVar command) {
        this(command, new IntVar(0));
    }

    public CommandPart(StringVar command, IntVar delay) {
        this.command = command;
        this.setDelay(delay);
    }

    public String getRawCommand() {
        return this.command.getValue();
    }

    public String getParsedCommand(Level level, int x, int y, int z, Player player) {
        UUID uuid;
        int randId;
        String randIDStr;
        int index;
        String parsedCommand = this.command.getValue();
        parsedCommand = parsedCommand.replace("%player", player.m_7755_().getString());
        parsedCommand = parsedCommand.replace("%x", "" + x);
        parsedCommand = parsedCommand.replace("%y", "" + y);
        parsedCommand = parsedCommand.replace("%z", "" + z);
        parsedCommand = parsedCommand.replace("%pyaw", "" + player.m_146908_());
        parsedCommand = parsedCommand.replace("%ppitch", "" + player.m_146909_());
        parsedCommand = parsedCommand.replace("%px", "" + player.m_20185_());
        parsedCommand = parsedCommand.replace("%py", "" + player.m_20186_());
        parsedCommand = parsedCommand.replace("%pz", "" + player.m_20189_());
        parsedCommand = parsedCommand.replace("%puuid", player.m_20149_());
        int[] enc = UUIDUtil.m_235881_((UUID)player.m_20148_());
        parsedCommand = parsedCommand.replace("%pencuuid", String.format("[I;%d,%d,%d,%d]", enc[0], enc[1], enc[2], enc[3]));
        parsedCommand = parsedCommand.replace("%pdir", player.m_6350_().toString());
        while ((index = parsedCommand.indexOf("%randuuid")) != -1) {
            randIDStr = parsedCommand.substring(index + 9, index + 10);
            randId = 0;
            if (randIDStr.matches("\\d")) {
                randId = Integer.parseInt(randIDStr);
            }
            uuid = randUUIDs.computeIfAbsent(randId, id -> UUID.randomUUID());
            parsedCommand.replace("%randuuid" + randIDStr, uuid.toString());
        }
        while ((index = parsedCommand.indexOf("%randencuuid")) != -1) {
            randIDStr = parsedCommand.substring(index + 12, index + 13);
            randId = 0;
            if (randIDStr.matches("\\d")) {
                randId = Integer.parseInt(randIDStr);
            }
            uuid = randUUIDs.computeIfAbsent(randId, id -> UUID.randomUUID());
            enc = UUIDUtil.m_235881_((UUID)uuid);
            parsedCommand = parsedCommand.replace("%randencuuid", String.format("[I;%d,%d,%d,%d]", enc[0], enc[1], enc[2], enc[3]));
        }
        return parsedCommand;
    }

    public IntVar getCopies() {
        return this.copies;
    }

    public void setCopies(IntVar copies) {
        this.copies = copies;
    }

    public BoolVar areCopiesSoft() {
        return this.copiesSoft;
    }

    public void setCopiesSoft(BoolVar copiesSoft) {
        this.copiesSoft = copiesSoft;
    }

    public void setRelativeToPlayer(BoolVar boolVar) {
        this.relativeToPlayer = boolVar;
    }

    public BoolVar isRelativeToPlayer() {
        return this.relativeToPlayer;
    }
}

