/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfectionReward
extends BaseCustomReward {
    private final BlockState[] whitelist = new BlockState[]{Blocks.f_50080_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50186_.m_49966_(), Blocks.f_50078_.m_49966_(), Blocks.f_50129_.m_49966_(), RewardsUtil.getRandomWool(), Blocks.f_50076_.m_49966_(), Blocks.f_50033_.m_49966_(), Blocks.f_50141_.m_49966_(), Blocks.f_50134_.m_49966_()};
    private final BlockPos[] touchingPos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 1, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, -1, 0)};

    public BlockInfectionReward() {
        super("chancecubes:world_infection", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        int delay = 0;
        int delayShorten = 20;
        BlockPos lastPos = pos;
        ArrayList<BlockPos> possibleBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> changedBlocks = new ArrayList<BlockPos>();
        changedBlocks.add(new BlockPos(0, 0, 0));
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.addSurroundingBlocks((Level)level, pos, new BlockPos(0, 0, 0), changedBlocks, possibleBlocks);
        for (int i = 0; i < 5000; ++i) {
            BlockPos nextPos;
            if (possibleBlocks.size() > 0) {
                int index = RewardsUtil.rand.nextInt(possibleBlocks.size());
                nextPos = (BlockPos)possibleBlocks.get(index);
                possibleBlocks.remove(index);
            } else {
                nextPos = lastPos.m_121955_((Vec3i)this.touchingPos[RewardsUtil.rand.nextInt(this.touchingPos.length)]);
            }
            changedBlocks.add(nextPos);
            this.addSurroundingBlocks((Level)level, pos, nextPos, changedBlocks, possibleBlocks);
            BlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(nextPos.m_123341_(), nextPos.m_123342_(), nextPos.m_123343_(), state, false, delay / delayShorten));
            ++delay;
            lastPos = nextPos;
        }
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }

    private void addSurroundingBlocks(Level level, BlockPos worldCord, BlockPos offsetCord, List<BlockPos> changedBlocks, List<BlockPos> possibleBlocks) {
        for (BlockPos pos : this.touchingPos) {
            BlockPos checkPos = offsetCord.m_121955_((Vec3i)pos);
            if (changedBlocks.contains(checkPos) || possibleBlocks.contains(checkPos) || level.m_8055_(worldCord.m_121955_((Vec3i)checkPos)).m_60734_() instanceof AirBlock) continue;
            possibleBlocks.add(checkPos);
        }
    }
}

