/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import top.seraphjack.simplelogin.network.MessageChangePassword;
import top.seraphjack.simplelogin.network.MessageChangePasswordResponse;
import top.seraphjack.simplelogin.network.MessageLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;

public class NetworkLoader {
    private static final String PROTOCOL_VERSION = "1.1";
    public static SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simplelogin", "main"), () -> "1.1", "1.1"::equals, "1.1"::equals);
    private static int id = 0;

    private NetworkLoader() {
        throw new UnsupportedOperationException("No instance");
    }

    public static void registerPackets() {
        NetworkLoader.registerPacket(MessageLogin.class, MessageLogin::encode, MessageLogin::decode, MessageLogin::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkLoader.registerPacket(MessageRequestLogin.class, MessageRequestLogin::encode, MessageRequestLogin::decode, MessageRequestLogin::handle, NetworkDirection.PLAY_TO_CLIENT);
        NetworkLoader.registerPacket(MessageChangePassword.class, MessageChangePassword::encode, MessageChangePassword::decode, MessageChangePassword::handle, NetworkDirection.PLAY_TO_SERVER);
        NetworkLoader.registerPacket(MessageChangePasswordResponse.class, MessageChangePasswordResponse::encode, MessageChangePasswordResponse::decode, MessageChangePasswordResponse::handle, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG> void registerPacket(Class<MSG> msg, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler, NetworkDirection direction) {
        INSTANCE.registerMessage(id++, msg, encoder, decoder, handler, Optional.of(direction));
    }
}

