/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.detail;

import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.detail.IDetailProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DetailRegistryImpl<T>
implements DetailRegistry<T> {
    private final Collection<IDetailProvider<T>> providers = new ArrayList<IDetailProvider<T>>();
    private final IDetailProvider<T> basic;

    public DetailRegistryImpl(IDetailProvider<T> basic) {
        this.basic = basic;
        this.providers.add(basic);
    }

    @Override
    public synchronized void addProvider(IDetailProvider<T> provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        if (!this.providers.contains(provider)) {
            this.providers.add(provider);
        }
    }

    @Override
    public Map<String, Object> getBasicDetails(T object) {
        Objects.requireNonNull(object, "object cannot be null");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        this.basic.provideDetails(map, object);
        return map;
    }

    @Override
    public Map<String, Object> getDetails(T object) {
        Objects.requireNonNull(object, "object cannot be null");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IDetailProvider<T> provider : this.providers) {
            provider.provideDetails(map, object);
        }
        return map;
    }
}

