/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core;

import dan200.computercraft.core.computer.ComputerThread;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.ILuaMachine;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;

public final class ComputerContext {
    private final GlobalEnvironment globalEnvironment;
    private final ComputerThread computerScheduler;
    private final MainThreadScheduler mainThreadScheduler;
    private final ILuaMachine.Factory factory;

    public ComputerContext(GlobalEnvironment globalEnvironment, ComputerThread computerScheduler, MainThreadScheduler mainThreadScheduler, ILuaMachine.Factory factory) {
        this.globalEnvironment = globalEnvironment;
        this.computerScheduler = computerScheduler;
        this.mainThreadScheduler = mainThreadScheduler;
        this.factory = factory;
    }

    public ComputerContext(GlobalEnvironment environment, int threads, MainThreadScheduler mainThreadScheduler) {
        this(environment, new ComputerThread(threads), mainThreadScheduler, CobaltLuaMachine::new);
    }

    public GlobalEnvironment globalEnvironment() {
        return this.globalEnvironment;
    }

    public ComputerThread computerScheduler() {
        return this.computerScheduler;
    }

    public MainThreadScheduler mainThreadScheduler() {
        return this.mainThreadScheduler;
    }

    public ILuaMachine.Factory luaFactory() {
        return this.factory;
    }

    @CheckReturnValue
    public boolean close(long timeout, TimeUnit unit) throws InterruptedException {
        return this.computerScheduler().stop(timeout, unit);
    }

    public void ensureClosed(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.computerScheduler().stop(timeout, unit)) {
            throw new IllegalStateException("Failed to shutdown ComputerContext in time.");
        }
    }
}

