/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.core.tools.DataTool;
import me.srrapero720.watermedia.core.tools.NetTool;

public class TwitterFixer
extends URLFixer {
    private static final String API_URL = "https://cdn.syndication.twimg.com/tweet-result?id=%s&token=%s&lang=en";
    private static final String API_KEY = "watermedia-java-x-access-token";
    private static final Pattern ID_PATTERN = Pattern.compile("^/([A-Za-z0-9_]+)/status/(\\d+)$");
    private static final Pattern RES_PATTERN = Pattern.compile("(\\d+)x(\\d+)");
    private static final String __TYPE_T = "Tweet";
    private static final String __TYTE_TOMB = "TweetTombstone";

    @Override
    public String platform() {
        return "Twitter (X)";
    }

    @Override
    public boolean isValid(URL source) {
        String host = source.getHost();
        String path = source.getPath();
        return (host.equals("www.x.com") || host.equals("x.com") || host.equals("www.twitter.com") || host.equals("twitter.com")) && ID_PATTERN.matcher(path).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality prefQuality) throws URLFixer.FixingURLException {
        try {
            Matcher m = ID_PATTERN.matcher(url.getPath());
            if (!m.matches()) {
                throw new Exception("No twitter ID match found");
            }
            String apiURL = String.format(API_URL, m.group(2), API_KEY);
            HttpURLConnection conn = NetTool.connect(apiURL, "GET");
            int code = conn.getResponseCode();
            switch (code) {
                case 500: {
                    throw new Exception("Twitter died");
                }
                case 404: {
                    throw new NullPointerException("Tweet not found");
                }
                case 401: 
                case 403: {
                    throw new UnsupportedOperationException("Twitter blocked us API access - URL: " + apiURL);
                }
            }
            if (code != 200) {
                throw new UnsupportedOperationException("Unexpected response from twitter (" + code + ") - URL: " + apiURL);
            }
            try (InputStream in = conn.getInputStream();){
                Tweet tweet = (Tweet)DataTool.fromJSON(new String(DataTool.readAllBytes(in)), Tweet.class);
                if (tweet.typename.equals(__TYTE_TOMB)) {
                    throw new UnsupportedOperationException("Tomb received: " + tweet.tombstone.text);
                }
                if (tweet.mediaDetails == null) throw new NullPointerException("No media was detected");
                if (tweet.mediaDetails.length == 0) {
                    throw new NullPointerException("No media was detected");
                }
                MediaDetail media = tweet.mediaDetails[0];
                if (media.type.equals("photo")) {
                    URLFixer.Result result = new URLFixer.Result(new URL(media.mediaUrlHttps), false, false);
                    return result;
                }
                if (!media.type.equals("video")) throw new UnsupportedOperationException("Unsupported media type was detected");
                URLFixer.Result result = new URLFixer.Result(new URL(media.videoInfo.variants[0].url), true, false);
                return result;
            }
            finally {
                conn.disconnect();
            }
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url, (Throwable)e);
        }
    }

    private static class Tweet {
        @SerializedName(value="__typename")
        public String typename;
        @SerializedName(value="lang")
        public String lang;
        @SerializedName(value="favorite_count")
        public int favoriteCount;
        @SerializedName(value="possibly_sensitive")
        public boolean possiblySensitive;
        @SerializedName(value="created_at")
        public String createdAt;
        @SerializedName(value="id_str")
        public String idStr;
        @SerializedName(value="text")
        public String text;
        @SerializedName(value="user")
        public User user;
        @SerializedName(value="mediaDetails")
        public MediaDetail[] mediaDetails;
        @SerializedName(value="photos")
        public Photo[] photos;
        @SerializedName(value="video")
        public Video video;
        @SerializedName(value="tombstone")
        public Tombstone tombstone;

        private Tweet() {
        }
    }

    private static class Tombstone {
        @SerializedName(value="text")
        public Text text;

        private Tombstone() {
        }
    }

    private static class Text {
        @SerializedName(value="text")
        public String text;
        @SerializedName(value="rtl")
        public boolean rtl;

        private Text() {
        }
    }

    private static class MediaDetail {
        @SerializedName(value="display_url")
        public String displayUrl;
        @SerializedName(value="expanded_url")
        public String expandedUrl;
        @SerializedName(value="media_url_https")
        public String mediaUrlHttps;
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="video_info")
        public VideoInfo videoInfo;

        private MediaDetail() {
        }
    }

    private static class VideoInfo {
        @SerializedName(value="duration_millis")
        public int durationMillis;
        @SerializedName(value="variants")
        public VideoVariant[] variants;

        private VideoInfo() {
        }
    }

    private static class VideoVariant {
        @SerializedName(value="bitrate")
        public int bitrate;
        @SerializedName(value="content_type")
        public String contentType;
        @SerializedName(value="url")
        public String url;

        private VideoVariant() {
        }
    }

    private static class Media {
        @SerializedName(value="display_url")
        public String displayUrl;
        @SerializedName(value="expanded_url")
        public String expandedUrl;
        @SerializedName(value="url")
        public String url;

        private Media() {
        }
    }

    private static class User {
        @SerializedName(value="id_str")
        public String idStr;
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="profile_image_url_https")
        public String profileImageUrlHttps;
        @SerializedName(value="screen_name")
        public String screenName;
        @SerializedName(value="verified")
        public boolean verified;
        @SerializedName(value="is_blue_verified")
        public boolean isBlueVerified;

        private User() {
        }
    }

    private static class Photo {
        @SerializedName(value="url")
        public String url;
        @SerializedName(value="width")
        public int width;
        @SerializedName(value="height")
        public int height;

        private Photo() {
        }
    }

    private static class Video {
        @SerializedName(value="aspectRatio")
        public int[] aspectRatio;
        @SerializedName(value="contentType")
        public String contentType;
        @SerializedName(value="durationMs")
        public long durationMs;
        @SerializedName(value="poster")
        public String poster;
        @SerializedName(value="variants")
        public VideoVariant[] variants;

        private Video() {
        }
    }
}

