/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.image.ImageCache;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.image.decoders.GifDecoder;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.core.tools.IOTool;
import me.srrapero720.watermedia.core.tools.JarTool;
import me.srrapero720.watermedia.loaders.ILoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ImageAPI
extends WaterMediaAPI {
    public static final Marker IT = MarkerManager.getMarker((String)ImageAPI.class.getSimpleName());
    private static final Map<String, ImageRenderer> LOADING_CACHE = new HashMap<String, ImageRenderer>();
    private static ImageRenderer IMG_LOADING;
    private static ImageRenderer IMG_VLC_FAIL;
    private static ImageRenderer IMG_VLC_FAIL_LAND;
    private static ImageRenderer IMG_BLACK;
    private Path loadingGifPath;

    public static ImageRenderer failedVLC() {
        return IMG_VLC_FAIL;
    }

    public static ImageRenderer failedVLCLandscape() {
        return IMG_VLC_FAIL_LAND;
    }

    public static ImageRenderer loadingGif() {
        return IMG_LOADING;
    }

    public static ImageRenderer blackPicture() {
        return IMG_BLACK;
    }

    public static ImageRenderer loadingGif(String modId) {
        Path processDir = WaterMedia.getLoader().processDir();
        Path modConfig = processDir.resolve("config/watermedia/assets/" + modId + "/loading.gif");
        if (Files.exists(modConfig, new LinkOption[0])) {
            ImageRenderer renderer = LOADING_CACHE.get(modId);
            if (renderer != null) {
                WaterMedia.LOGGER.warn(IT, "Founded cached reference of '{}' loading gif, consider storing it in a STATIC param", (Object)modId);
                return renderer;
            }
            renderer = ImageAPI.renderer(IOTool.readGif(modConfig.toAbsolutePath()));
            LOADING_CACHE.put(modId, renderer);
            return renderer;
        }
        File modConfigParent = modConfig.getParent().toFile();
        if (!modConfigParent.exists()) {
            WaterMedia.LOGGER.warn(IT, "Custom loading gif not found, creating directories and returning default one");
            if (!modConfigParent.mkdirs()) {
                WaterMedia.LOGGER.error("Cannot create dir '{}'", (Object)modConfigParent.toString());
            }
        } else {
            WaterMedia.LOGGER.error(IT, "Founded directories but custom loading gif is missing");
        }
        return IMG_LOADING;
    }

    public static ImageCache getCache(String originalURL, Executor renderThreadEx) {
        if (originalURL == null || originalURL.isEmpty()) {
            return ImageCache.EMPTY_INSTANCE;
        }
        ImageCache image = ImageCache.CACHE.get(originalURL);
        image = image == null ? new ImageCache(originalURL, renderThreadEx) : image.use();
        ImageCache.CACHE.put(originalURL, image);
        return image;
    }

    public static ImageCache createCache(ImageRenderer renderer) {
        return new ImageCache(renderer);
    }

    public static ImageCache createCache(BufferedImage image, boolean absolute) {
        return new ImageCache(ImageAPI.renderer(image, absolute));
    }

    public static void reloadCache() {
        for (ImageCache imageCache : ImageCache.CACHE.values()) {
            imageCache.reload();
        }
    }

    public static ImageRenderer renderer(BufferedImage image) {
        return ImageAPI.renderer(image, false);
    }

    public static ImageRenderer renderer(BufferedImage image, boolean absolute) {
        if (absolute) {
            return new ImageRenderer(image);
        }
        return new ImageRenderer.Absolute(image);
    }

    public static ImageRenderer renderer(GifDecoder image) {
        return ImageAPI.renderer(image, false);
    }

    public static ImageRenderer renderer(GifDecoder image, boolean absolute) {
        if (!absolute) {
            return new ImageRenderer(image);
        }
        return new ImageRenderer.Absolute(image);
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.HIGH;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        this.loadingGifPath = bootCore.processDir().resolve("config/watermedia/assets/loading.gif");
        if (!this.loadingGifPath.toFile().exists()) {
            WaterMedia.LOGGER.info(IT, "Extracting default loading gif...");
            JarTool.copyAsset("/pictures/loading.gif", this.loadingGifPath);
            WaterMedia.LOGGER.info(IT, "Extracted successfully");
        }
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        if (IMG_LOADING != null) {
            // empty if block
        }
        WaterMedia.LOGGER.info(IT, "Loading image resources in a {} instance", (Object)ImageRenderer.class.getSimpleName());
        IMG_LOADING = ImageAPI.renderer(IOTool.readGif(this.loadingGifPath), true);
        IMG_VLC_FAIL = ImageAPI.renderer(JarTool.readGif("/pictures/videolan/failed.gif"), true);
        IMG_VLC_FAIL_LAND = ImageAPI.renderer(JarTool.readGif("/pictures/videolan/failed-land.gif"), true);
        BufferedImage image = new BufferedImage(1, 1, 2);
        image.setRGB(0, 0, MathAPI.argb(255, 0, 0, 0));
        IMG_BLACK = ImageAPI.renderer(image);
    }

    @Override
    public void release() {
        IMG_LOADING.release();
        IMG_VLC_FAIL.release();
        IMG_VLC_FAIL_LAND.release();
        IMG_BLACK.release();
        IMG_LOADING = null;
        IMG_VLC_FAIL = null;
        IMG_VLC_FAIL_LAND = null;
        IMG_BLACK = null;
    }
}

