/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.ThreadedParameters;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import org.apache.logging.log4j.Logger;

public final class StepStructureStart {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ChunkStatus STATUS = ChunkStatus.f_62315_;
    private static final ReentrantLock STRUCTURE_PLACEMENT_LOCK = new ReentrantLock();
    private final BatchGenerationEnvironment environment;

    public StepStructureStart(BatchGenerationEnvironment batchGenerationEnvironment) {
        this.environment = batchGenerationEnvironment;
    }

    public void generateGroup(ThreadedParameters tParams, WorldGenRegion worldGenRegion, List<ChunkWrapper> chunkWrappers) throws InterruptedException {
        ArrayList chunksToDo = new ArrayList();
        for (ChunkWrapper chunkWrapper : chunkWrappers) {
            ChunkAccess chunk = chunkWrapper.getChunk();
            if (chunkWrapper.getStatus().m_62427_(STATUS) || !(chunk instanceof ProtoChunk)) continue;
            chunkWrapper.trySetStatus(STATUS);
        }
        if (this.environment.params.worldGenSettings.m_224677_()) {
            for (ChunkAccess chunk : chunksToDo) {
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                STRUCTURE_PLACEMENT_LOCK.lock();
                this.environment.params.generator.m_223164_(this.environment.params.registry, this.environment.params.randomState, (StructureManager)tParams.structFeat, chunk, this.environment.params.structures, this.environment.params.worldSeed);
                try {
                    tParams.structCheck.m_197282_(chunk.m_7697_(), chunk.m_6633_());
                }
                catch (ArrayIndexOutOfBoundsException firstEx) {
                    tParams.recreateStructureCheck();
                    try {
                        tParams.structCheck.m_197282_(chunk.m_7697_(), chunk.m_6633_());
                    }
                    catch (ArrayIndexOutOfBoundsException secondEx) {
                        LOGGER.error("Unable to create structure starts for " + String.valueOf(chunk.m_7697_()) + ". This is an error with MC's world generation. Ignoring and continuing generation. Error: " + secondEx.getMessage());
                    }
                }
                STRUCTURE_PLACEMENT_LOCK.unlock();
            }
        }
    }

    public static class StructStartCorruptedException
    extends RuntimeException {
        private static final long serialVersionUID = -8987434342051563358L;

        public StructStartCorruptedException(ArrayIndexOutOfBoundsException e) {
            super("StructStartCorruptedException");
            super.initCause(e);
            this.fillInStackTrace();
        }
    }
}

