/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2843;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_6749;
import net.minecraft.class_6755;
import net.minecraft.class_7522;
import org.jetbrains.annotations.Nullable;

public class ChunkLoader {
    private static final AtomicBoolean ZERO_CHUNK_POS_ERROR_LOGGED_REF = new AtomicBoolean(false);
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;
    private static boolean lightingSectionErrorLogged = false;
    private static final ConcurrentHashMap<String, Object> LOGGED_ERROR_MESSAGE_MAP = new ConcurrentHashMap();

    public static class_2818 read(class_5281 level, class_1923 chunkPos, class_2487 chunkData) {
        int chunkZ;
        class_2487 tagLevel = chunkData;
        int chunkX = ChunkLoader.tagGetInt(tagLevel, "xPos");
        class_1923 actualPos = new class_1923(chunkX, chunkZ = ChunkLoader.tagGetInt(tagLevel, "zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            if (chunkX == 0 && chunkZ == 0) {
                if (!ZERO_CHUNK_POS_ERROR_LOGGED_REF.getAndSet(true)) {
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualPos.toString() + "])", new Object[0]);
                return null;
            }
        }
        class_2806.class_2808 chunkType = ChunkLoader.readChunkType(tagLevel);
        class_6749 blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == class_2806.class_2808.field_12808 && blendingData == null) {
            return null;
        }
        long inhabitedTime = ChunkLoader.tagGetLong(tagLevel, "InhabitedTime");
        class_2843 upgradeData = class_2843.field_12950;
        boolean isLightOn = ChunkLoader.tagGetBoolean(tagLevel, "isLightOn");
        class_6755 blockTicks = class_6755.method_39368((class_2499)tagLevel.method_10554(BLOCK_TICKS_TAG_18, 10), string -> class_2378.field_11146.method_17966(class_2960.method_12829((String)string)), (class_1923)chunkPos);
        class_6755 fluidTicks = class_6755.method_39368((class_2499)tagLevel.method_10554(FLUID_TICKS_TAG_18, 10), string -> class_2378.field_11154.method_17966(class_2960.method_12829((String)string)), (class_1923)chunkPos);
        class_2826[] levelChunkSections = ChunkLoader.readSections((class_1936)level, chunkPos, tagLevel);
        class_2818 chunk = new class_2818((class_1937)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.method_12020(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        return chunk;
    }

    private static class_2826[] readSections(class_1936 level, class_1923 chunkPos, class_2487 chunkData) {
        class_2378 biomes = level.method_30349().method_30530(class_2378.field_25114);
        Codec biomeCodec = class_2841.method_44343((class_2359)biomes.method_40295(), (Codec)biomes.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)biomes.method_40290(class_1972.field_9451));
        int sectionYIndex = level.method_32890();
        class_2826[] chunkSections = new class_2826[sectionYIndex];
        class_2499 tagSections = ChunkLoader.tagGetListTag(chunkData, "Sections", 10);
        if (tagSections == null || tagSections.isEmpty()) {
            tagSections = ChunkLoader.tagGetListTag(chunkData, "sections", 10);
        }
        if (tagSections != null) {
            for (int j = 0; j < tagSections.size(); ++j) {
                byte sectionYPos;
                int sectionId;
                class_2487 tagSection = ChunkLoader.tagGetCompoundTag(tagSections, j);
                if (tagSection == null || (sectionId = level.method_31603((int)(sectionYPos = ChunkLoader.tagGetByte(tagSection, "Y")))) < 0 || sectionId >= chunkSections.length) continue;
                boolean containsBlockStates = tagSection.method_10573("block_states", 10);
                class_2841 blockStateContainer = containsBlockStates ? (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)ChunkLoader.tagGetCompoundTag(tagSection, "block_states")).promotePartial(string -> ChunkLoader.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(false, message -> ChunkLoader.logParsingWarningOnce(message)) : new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                boolean containsBiomes = tagSection.method_10573("biomes", 10);
                class_2841 biomeContainer = containsBiomes ? (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)ChunkLoader.tagGetCompoundTag(tagSection, "biomes")).promotePartial(string -> ChunkLoader.logBiomeDeserializationWarning(chunkPos, sectionYIndex, string)).getOrThrow(false, message -> ChunkLoader.logParsingWarningOnce(message)) : new class_2841(biomes.method_40295(), (Object)biomes.method_40290(class_1972.field_9451), class_2841.class_6563.field_34570);
                chunkSections[sectionId] = new class_2826((int)sectionYPos, blockStateContainer, (class_7522)biomeContainer);
            }
        }
        return chunkSections;
    }

    private static class_2806.class_2808 readChunkType(class_2487 tagLevel) {
        class_2806 chunkStatus;
        String statusString = ChunkLoader.tagGetString(tagLevel, "Status");
        if (statusString != null && (chunkStatus = class_2806.method_12168((String)statusString)) != null) {
            return chunkStatus.method_12164();
        }
        return class_2806.class_2808.field_12808;
    }

    private static void readHeightmaps(class_2818 chunk, class_2487 chunkData) {
        class_2487 tagHeightmaps = ChunkLoader.tagGetCompoundTag(chunkData, "Heightmaps");
        if (tagHeightmaps != null) {
            for (class_2902.class_2903 type2 : class_2806.field_12803.method_12160()) {
                String heightmap = type2.method_12605();
                if (!tagHeightmaps.method_10573(heightmap, 12)) continue;
                chunk.method_12037(type2, tagHeightmaps.method_10565(heightmap));
            }
            class_2902.method_16684((class_2791)chunk, (Set)class_2806.field_12803.method_12160());
        }
    }

    private static class_6749 readBlendingData(class_2487 chunkData) {
        class_6749 blendingData = null;
        boolean containsBlendingData = chunkData.method_10573("blending_data", 10);
        if (containsBlendingData) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)class_2509.field_11560, (Object)chunkData.method_10562("blending_data"));
            try {
                blendingData = class_6749.field_35682.parse(blendingDataTag).resultOrPartial(message -> ChunkLoader.logParsingWarningOnce(message)).orElse(null);
            }
            catch (Exception e) {
                String message2 = e.getMessage();
                if (message2 == null || message2.trim().isEmpty()) {
                    message2 = "Failed to parse blending data";
                }
                ChunkLoader.logParsingWarningOnce(message2, e);
            }
        }
        return blendingData;
    }

    public static CombinedChunkLightStorage readLight(class_2791 chunk, class_2487 chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        class_2520 chunkSectionTags = chunkData.method_10580("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.method_12004()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof class_2499)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + class_2499.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        class_2499 chunkSectionListTag = (class_2499)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            class_2520 chunkSectionTag = chunkSectionListTag.method_10534(sectionIndex);
            if (!(chunkSectionTag instanceof class_2487)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + class_2487.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            class_2487 chunkSectionCompoundTag = (class_2487)chunkSectionTag;
            byte[] blockLightNibbleArray = ChunkLoader.tagGetByteArray(chunkSectionCompoundTag, "BlockLight");
            byte[] skyLightNibbleArray = ChunkLoader.tagGetByteArray(chunkSectionCompoundTag, "SkyLight");
            if (blockLightNibbleArray == null || skyLightNibbleArray == null) continue;
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkLoader.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkLoader.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(class_1923 chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.field_9181 + ", " + sectionYIndex + ", " + chunkPos.field_9180 + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logBiomeDeserializationWarning(class_1923 chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.field_9181 + ", " + sectionYIndex + ", " + chunkPos.field_9180 + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logParsingWarningOnce(String message) {
        ChunkLoader.logParsingWarningOnce(message, null);
    }

    private static void logParsingWarningOnce(String message, Exception e) {
        if (message == null) {
            return;
        }
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", e);
            return newMessage;
        });
    }

    private static RuntimeException logErrorAndReturnException(String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
        return null;
    }

    private static boolean tagGetBoolean(class_2487 tag, String key) {
        return tag.method_10577(key);
    }

    private static byte tagGetByte(class_2487 tag, String key) {
        return tag.method_10571(key);
    }

    private static short tagGetShort(class_2499 tag, int index) {
        return tag.method_10609(index);
    }

    private static int tagGetInt(class_2487 tag, String key) {
        return tag.method_10550(key);
    }

    private static long tagGetLong(class_2487 tag, String key) {
        return tag.method_10550(key);
    }

    @Nullable
    private static String tagGetString(class_2487 tag, String key) {
        return tag.method_10558(key);
    }

    @Nullable
    private static byte[] tagGetByteArray(class_2487 tag, String key) {
        return tag.method_10547(key);
    }

    @Nullable
    private static class_2487 tagGetCompoundTag(class_2487 tag, String key) {
        return tag.method_10562(key);
    }

    @Nullable
    private static class_2487 tagGetCompoundTag(class_2499 tag, int index) {
        return tag.method_10602(index);
    }

    @Nullable
    private static class_2499 tagGetListTag(class_2487 tag, String key, int elementType) {
        return tag.method_10554(key, elementType);
    }

    @Nullable
    private static class_2499 tagGetListTag(class_2499 tag, int index) {
        return tag.method_10603(index);
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

