/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import DistantHorizons.libraries.joml.Matrix4f;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiCullingFrustum;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShadowCullingFrustum;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.render.DhFrustumBounds;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.render.NeverCullFrustum;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.util.objects.SortedArraySet;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class RenderBufferHandler
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final IIrisAccessor IRIS_ACCESSOR = ModAccessorInjector.INSTANCE.get(IIrisAccessor.class);
    public final LodQuadTree lodQuadTree;
    private SortedArraySet<LoadedRenderBuffer> loadedNearToFarBuffers = null;
    private final AtomicBoolean rebuildAllBuffers = new AtomicBoolean(false);
    private int visibleBufferCount;
    private int culledBufferCount;
    private int shadowVisibleBufferCount;
    private int shadowCulledBufferCount;

    public RenderBufferHandler(LodQuadTree lodQuadTree) {
        IDhApiShadowCullingFrustum coreShadowFrustum;
        this.lodQuadTree = lodQuadTree;
        IDhApiCullingFrustum coreCameraFrustum = DhApi.overrides.get(IDhApiCullingFrustum.class, -1);
        if (coreCameraFrustum == null) {
            DhApi.overrides.bind(IDhApiCullingFrustum.class, new DhFrustumBounds());
        }
        if ((coreShadowFrustum = DhApi.overrides.get(IDhApiShadowCullingFrustum.class, -1)) == null) {
            DhApi.overrides.bind(IDhApiShadowCullingFrustum.class, new NeverCullFrustum());
        }
    }

    public void buildRenderListAndUpdateSections(IClientLevelWrapper clientLevelWrapper, DhApiRenderParam renderEventParam, Vec3f lookForwardVector) {
        IDhApiCullingFrustum frustum;
        boolean enableFrustumCulling;
        boolean isShadowPass;
        EDhDirection zDir;
        EDhDirection[] axisDirections = new EDhDirection[3];
        float absX = Math.abs(lookForwardVector.x);
        float absY = Math.abs(lookForwardVector.y);
        float absZ = Math.abs(lookForwardVector.z);
        EDhDirection xDir = lookForwardVector.x < 0.0f ? EDhDirection.EAST : EDhDirection.WEST;
        EDhDirection yDir = lookForwardVector.y < 0.0f ? EDhDirection.UP : EDhDirection.DOWN;
        EDhDirection eDhDirection = zDir = lookForwardVector.z < 0.0f ? EDhDirection.SOUTH : EDhDirection.NORTH;
        if (absX >= absY && absX >= absZ) {
            axisDirections[0] = xDir;
            if (absY >= absZ) {
                axisDirections[1] = yDir;
                axisDirections[2] = zDir;
            } else {
                axisDirections[1] = zDir;
                axisDirections[2] = yDir;
            }
        } else if (absY >= absX && absY >= absZ) {
            axisDirections[0] = yDir;
            if (absX >= absZ) {
                axisDirections[1] = xDir;
                axisDirections[2] = zDir;
            } else {
                axisDirections[1] = zDir;
                axisDirections[2] = xDir;
            }
        } else {
            axisDirections[0] = zDir;
            if (absX >= absY) {
                axisDirections[1] = xDir;
                axisDirections[2] = yDir;
            } else {
                axisDirections[1] = yDir;
                axisDirections[2] = xDir;
            }
        }
        Pos2D cPos = this.lodQuadTree.getCenterBlockPos().toPos2D();
        Comparator farToNearComparator = (loadedBufferA, loadedBufferB) -> {
            Pos2D aPos = DhSectionPos.getCenterBlockPos(loadedBufferA.pos).toPos2D();
            Pos2D bPos = DhSectionPos.getCenterBlockPos(loadedBufferB.pos).toPos2D();
            int aManhattanDistance = aPos.manhattanDist(cPos);
            int bManhattanDistance = bPos.manhattanDist(cPos);
            return bManhattanDistance - aManhattanDistance;
        };
        this.loadedNearToFarBuffers = new SortedArraySet((a, b) -> -farToNearComparator.compare(a, b));
        boolean bl = isShadowPass = IRIS_ACCESSOR != null && IRIS_ACCESSOR.isRenderingShadowPass();
        if (isShadowPass) {
            enableFrustumCulling = Config.Client.Advanced.Graphics.Culling.disableShadowPassFrustumCulling.get() == false;
            frustum = DhApi.overrides.get(IDhApiShadowCullingFrustum.class);
        } else {
            enableFrustumCulling = Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get() == false;
            frustum = DhApi.overrides.get(IDhApiCullingFrustum.class);
        }
        if (enableFrustumCulling) {
            int worldMinY = clientLevelWrapper.getMinHeight();
            int worldHeight = clientLevelWrapper.getMaxHeight();
            Vec3d cameraPos = MC_RENDER.getCameraExactPosition();
            Matrix4f matWorldView = new Matrix4f().setTransposed(renderEventParam.mcModelViewMatrix.getValuesAsArray()).translate(-((float)cameraPos.x), -((float)cameraPos.y), -((float)cameraPos.z));
            Matrix4f matWorldViewProjection = new Matrix4f().setTransposed(renderEventParam.dhProjectionMatrix.getValuesAsArray()).mul(matWorldView);
            frustum.update(worldMinY, worldMinY + worldHeight, new Mat4f(matWorldViewProjection));
        }
        if (isShadowPass) {
            this.shadowCulledBufferCount = 0;
        } else {
            this.culledBufferCount = 0;
        }
        boolean rebuildAllBuffers = this.rebuildAllBuffers.getAndSet(false);
        Iterator nodeIterator = this.lodQuadTree.nodeIterator();
        while (nodeIterator.hasNext()) {
            QuadNode node = nodeIterator.next();
            long sectionPos = node.sectionPos;
            LodRenderSection renderSection = (LodRenderSection)node.value;
            if (renderSection == null) continue;
            try {
                int lodBlockWidth;
                int blockMinZ;
                DhLodPos lodBounds;
                int blockMinX;
                if (enableFrustumCulling && !frustum.intersects(blockMinX = (lodBounds = DhSectionPos.getSectionBBoxPos(renderSection.pos)).getMinX().toBlockWidth(), blockMinZ = lodBounds.getMinZ().toBlockWidth(), lodBlockWidth = lodBounds.getBlockWidth(), lodBounds.detailLevel)) {
                    if (isShadowPass) {
                        ++this.shadowCulledBufferCount;
                        continue;
                    }
                    ++this.culledBufferCount;
                    continue;
                }
                ColumnRenderBuffer buffer = renderSection.renderBuffer;
                if (buffer == null || !renderSection.getRenderingEnabled()) continue;
                this.loadedNearToFarBuffers.add(new LoadedRenderBuffer(buffer, sectionPos));
            }
            catch (Exception e) {
                LOGGER.error("Error updating QuadTree render source at " + renderSection.pos + ".", (Throwable)e);
            }
        }
        if (isShadowPass) {
            this.shadowVisibleBufferCount = this.loadedNearToFarBuffers.size();
        } else {
            this.visibleBufferCount = this.loadedNearToFarBuffers.size();
        }
    }

    public void MarkAllBuffersDirty() {
        this.rebuildAllBuffers.set(true);
    }

    public void renderOpaque(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        this.renderPass(renderContext, renderEventParam, true);
    }

    public void renderTransparent(LodRenderer renderContext, DhApiRenderParam renderEventParam) {
        this.renderPass(renderContext, renderEventParam, false);
    }

    private void renderPass(LodRenderer renderContext, DhApiRenderParam renderEventParam, boolean opaquePass) {
        boolean renderWireframe = Config.Client.Advanced.Debugging.renderWireframe.get();
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6913);
            GLMC.disableFaceCulling();
        } else {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
        if (opaquePass) {
            if (this.loadedNearToFarBuffers != null) {
                this.loadedNearToFarBuffers.forEach(loadedBuffer -> loadedBuffer.buffer.renderOpaque(renderContext, renderEventParam));
            }
        } else if (this.loadedNearToFarBuffers != null) {
            ListIterator<LoadedRenderBuffer> iter = this.loadedNearToFarBuffers.listIterator(this.loadedNearToFarBuffers.size());
            while (iter.hasPrevious()) {
                LoadedRenderBuffer loadedBuffer2 = iter.previous();
                loadedBuffer2.buffer.renderTransparent(renderContext, renderEventParam);
            }
        }
        if (renderWireframe) {
            GL32.glPolygonMode((int)1032, (int)6914);
            GLMC.enableFaceCulling();
        }
    }

    public String getVboRenderDebugMenuString() {
        String countText = F3Screen.NUMBER_FORMAT.format(this.visibleBufferCount);
        if (!Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get().booleanValue()) {
            countText = countText + "/" + F3Screen.NUMBER_FORMAT.format(this.visibleBufferCount + this.culledBufferCount);
        }
        return LodUtil.formatLog("VBO Render Count: " + countText, new Object[0]);
    }

    public String getShadowPassRenderDebugMenuString() {
        boolean hasIrisShaders;
        boolean bl = hasIrisShaders = IRIS_ACCESSOR != null && IRIS_ACCESSOR.isShaderPackInUse();
        if (!hasIrisShaders) {
            return null;
        }
        String countText = F3Screen.NUMBER_FORMAT.format(this.shadowVisibleBufferCount);
        if (!Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get().booleanValue()) {
            countText = countText + "/" + F3Screen.NUMBER_FORMAT.format(this.shadowVisibleBufferCount + this.shadowCulledBufferCount);
        }
        return LodUtil.formatLog("Shadow VBO Render Count: " + countText, new Object[0]);
    }

    @Override
    public void close() {
        this.lodQuadTree.close();
    }

    private static class LoadedRenderBuffer {
        public final ColumnRenderBuffer buffer;
        public final long pos;

        LoadedRenderBuffer(ColumnRenderBuffer buffer, long pos) {
            this.buffer = buffer;
            this.pos = pos;
        }
    }
}

