/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.mixin.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.valhelsia.valhelsia_core.client.util.combiner.BlockCombineResult;
import net.valhelsia.valhelsia_core.client.util.combiner.BlockCombiner;
import net.valhelsia.valhelsia_core.client.util.combiner.PosBasedBrightnessCombiner;
import org.apache.commons.lang3.function.TriFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ModelBlockRenderer.class})
public class ModelBlockRendererMixin {
    private final Map<BlockPos, Integer> cachedPositions = new HashMap<BlockPos, Integer>();

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/ModelBlockRenderer;putQuadData(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lnet/minecraft/client/renderer/block/model/BakedQuad;FFFFIIIII)V"), method={"renderModelFaceFlat"}, ordinal=0, argsOnly=true)
    private int valhelsia_renderModelFaceFlat(int value, BlockAndTintGetter level, BlockState state, BlockPos pos) {
        for (Map.Entry<Predicate<BlockState>, TriFunction<BlockAndTintGetter, BlockState, BlockPos, BlockCombineResult<BlockPos>>> entry : BlockCombiner.BRIGHTNESS_COMBINERS.entrySet()) {
            if (!entry.getKey().test(state)) continue;
            BlockCombineResult combineResult = (BlockCombineResult)entry.getValue().apply((Object)level, (Object)state, (Object)pos);
            int newBrightness = combineResult.apply(new PosBasedBrightnessCombiner()).get(value);
            combineResult.getValues().forEach(blockPos -> {
                if (blockPos != pos) {
                    this.cachedPositions.put((BlockPos)blockPos, newBrightness);
                }
            });
            return newBrightness;
        }
        return value;
    }
}

