/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.event;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.helper.CounterHelper;
import net.valhelsia.valhelsia_core.common.network.NetworkHandler;
import net.valhelsia.valhelsia_core.common.network.RequestCosmeticsPacket;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.config.ConfigError;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

@Mod.EventBusSubscriber
public class PlayerEvents {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("valhelsia_core", "counters"), (ICapabilityProvider)new CounterProvider(CounterHelper.getCounters()));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
        for (RegistryManager registryManager : ValhelsiaCore.REGISTRY_MANAGERS) {
            AbstractConfigValidator configValidator;
            if (registryManager.configValidator() == null || (configValidator = registryManager.configValidator()).getType() != AbstractConfigValidator.Type.WORLD_LOAD) continue;
            configValidator.validate();
            configValidator.getErrors().forEach(configError -> configError.setModID(registryManager.modId()));
            errors.addAll(configValidator.getErrors());
        }
        if (!errors.isEmpty()) {
            errors.forEach(configError -> {
                player.m_213846_((Component)Component.m_237113_((String)configError.getModID()).m_130940_(ChatFormatting.UNDERLINE));
                player.m_213846_((Component)Component.m_237115_((String)"gui.valhelsia_core.config.error").m_130946_(": " + configError.getPath()));
                player.m_213846_((Component)configError.getErrorMessage());
            });
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            NetworkHandler.sendTo(player, new RequestCosmeticsPacket(target.m_20148_()));
        }
    }
}

