/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.event;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.client.gui.screen.ConfigErrorScreen;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.config.ConfigError;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiEvents {
    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof TitleScreen && !ValhelsiaCore.allConfigsValidated) {
            ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
            for (RegistryManager registryManager : ValhelsiaCore.REGISTRY_MANAGERS) {
                AbstractConfigValidator configValidator;
                if (registryManager.configValidator() == null || (configValidator = registryManager.configValidator()).getType() != AbstractConfigValidator.Type.LOAD_FINISH) continue;
                configValidator.validate();
                configValidator.getErrors().forEach(configError -> configError.setModID(registryManager.modId()));
                errors.addAll(configValidator.getErrors());
            }
            if (!errors.isEmpty()) {
                event.setCanceled(true);
                ConfigError error = (ConfigError)errors.get(0);
                errors.remove(error);
                Minecraft.m_91087_().m_91152_((Screen)(errors.isEmpty() ? new ConfigErrorScreen(error) : new ConfigErrorScreen(error, errors)));
            }
            ValhelsiaCore.allConfigsValidated = true;
        }
    }
}

