/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import com.github.eterdelta.crittersandcompanions.capability.ISilkLeashStateCapability;
import com.github.eterdelta.crittersandcompanions.entity.ILeashStateEntity;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class SilkLeashItem
extends Item {
    public SilkLeashItem(Item.Properties properties) {
        super(properties);
    }

    public static int updateLeashStates(LivingEntity leashOwner, LivingEntity leashedEntity) {
        Map<Entity, ISilkLeashStateCapability> updatedStates = SilkLeashItem.updateLeashStatesLocal(leashOwner, leashedEntity);
        if (!updatedStates.isEmpty()) {
            CACPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> leashOwner == null ? leashedEntity : leashOwner), (Object)new ClientboundSilkLeashStatePacket(updatedStates.entrySet().stream().map(entry -> new ClientboundSilkLeashStatePacket.LeashData(((Entity)entry.getKey()).m_19879_(), (IntList)new IntArrayList(((ISilkLeashStateCapability)entry.getValue()).getLeashingEntities().stream().mapToInt(Entity::m_19879_).toArray()), (IntList)new IntArrayList(((ISilkLeashStateCapability)entry.getValue()).getLeashedByEntities().stream().mapToInt(Entity::m_19879_).toArray()))).collect(Collectors.toList())));
        }
        return updatedStates.size();
    }

    public static Map<Entity, ISilkLeashStateCapability> updateLeashStatesLocal(LivingEntity leashOwner, LivingEntity leashedEntity) {
        if (leashOwner == null && leashedEntity == null) {
            throw new IllegalArgumentException("Both leash members cannot be null");
        }
        HashMap<LivingEntity, ISilkLeashStateCapability> modifiedEntities = new HashMap<LivingEntity, ISilkLeashStateCapability>();
        if (leashOwner == null) {
            LazyOptional<ISilkLeashStateCapability> leashedCap = ((ILeashStateEntity)leashedEntity).getLeashStateCache();
            ISilkLeashStateCapability leashedLeashState = (ISilkLeashStateCapability)leashedCap.orElseThrow(IllegalStateException::new);
            if (leashedLeashState.getLeashedByEntities().isEmpty()) {
                return Map.of();
            }
            for (Entity entity : leashedLeashState.getLeashedByEntities()) {
                entity.getCapability(CACCapabilities.SILK_LEASH_STATE).ifPresent(state -> {
                    state.getLeashingEntities().remove(leashedEntity);
                    modifiedEntities.put((LivingEntity)entity, (ISilkLeashStateCapability)state);
                });
            }
            leashedLeashState.getLeashedByEntities().clear();
            modifiedEntities.put(leashedEntity, leashedLeashState);
        } else {
            LazyOptional<ISilkLeashStateCapability> ownerCap = ((ILeashStateEntity)leashOwner).getLeashStateCache();
            ISilkLeashStateCapability ownerLeashState = (ISilkLeashStateCapability)ownerCap.orElseThrow(IllegalStateException::new);
            if (leashedEntity == null) {
                if (ownerLeashState.getLeashingEntities().isEmpty()) {
                    return Map.of();
                }
                for (Entity entity : ownerLeashState.getLeashingEntities()) {
                    entity.getCapability(CACCapabilities.SILK_LEASH_STATE).ifPresent(state -> {
                        state.getLeashedByEntities().remove(leashOwner);
                        modifiedEntities.put((LivingEntity)entity, (ISilkLeashStateCapability)state);
                    });
                }
                ownerLeashState.getLeashingEntities().clear();
            } else {
                if (!SilkLeashItem.canLeash((Entity)leashOwner, (Entity)leashedEntity)) {
                    return Map.of();
                }
                LazyOptional<ISilkLeashStateCapability> leashedEntityCap = ((ILeashStateEntity)leashedEntity).getLeashStateCache();
                leashedEntityCap.ifPresent(leashedEntityLeashState -> {
                    leashedEntityLeashState.getLeashedByEntities().add(leashOwner);
                    ownerLeashState.getLeashingEntities().add(leashedEntity);
                    modifiedEntities.put(leashedEntity, (ISilkLeashStateCapability)leashedEntityLeashState);
                });
            }
            modifiedEntities.put(leashOwner, ownerLeashState);
        }
        return Map.copyOf(modifiedEntities);
    }

    private static boolean canLeash(Entity sourceEntity, Entity targetEntity) {
        return sourceEntity.getCapability(CACCapabilities.SILK_LEASH_STATE).map(sourceLeashState -> {
            if (sourceEntity == targetEntity) {
                return false;
            }
            return Stream.concat(sourceLeashState.getLeashingEntities().stream(), sourceLeashState.getLeashedByEntities().stream()).noneMatch(entity -> entity == targetEntity);
        }).orElse(false);
    }

    public InteractionResult m_6880_(ItemStack handStack, Player player, LivingEntity entity, InteractionHand interactionHand) {
        ISilkLeashStateCapability playerLeashState;
        LazyOptional entityLeashCap;
        LazyOptional playerLeashCap = player.getCapability(CACCapabilities.SILK_LEASH_STATE);
        if (playerLeashCap.isPresent() && (entityLeashCap = entity.getCapability(CACCapabilities.SILK_LEASH_STATE)).isPresent() && handStack.m_150930_((Item)CACItems.SILK_LEAD.get()) && (playerLeashState = (ISilkLeashStateCapability)playerLeashCap.orElse(null)).getLeashingEntities().isEmpty()) {
            if (!player.m_150110_().f_35937_) {
                handStack.m_41774_(1);
            }
            if (!player.m_9236_().m_5776_()) {
                SilkLeashItem.updateLeashStates((LivingEntity)player, entity);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

