/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.item.DragonflyArmorItem;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DragonflyEntity
extends TamableAnimal
implements IAnimatable {
    private static final EntityDataAccessor<ItemStack> ARMOR_ITEM = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public DragonflyEntity(EntityType<? extends DragonflyEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DragonflyMoveControl(this);
        this.m_21441_(BlockPathTypes.OPEN, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22280_, 0.25);
    }

    public static boolean checkDragonflySpawnRules(EntityType<DragonflyEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource random) {
        return blockPos.m_123342_() > 63 && blockPos.m_123342_() <= levelAccessor.m_5736_() + 16 && levelAccessor.m_8055_(blockPos).m_60795_() && levelAccessor.m_45524_(blockPos, 0) > 8;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARMOR_ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 1.0, 6.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
        this.f_21345_.m_25352_(4, (Goal)new RandomFlyGoal());
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("ArmorItem", (Tag)this.getArmor().m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setArmor(ItemStack.m_41712_((CompoundTag)compound.m_128469_("ArmorItem")));
    }

    public int m_213860_() {
        return this.f_19796_.m_216339_(2, 5);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    public float m_21692_(BlockPos blockPos) {
        return !this.m_21824_() && this.f_19853_.m_204166_(blockPos).m_203565_(Biomes.f_48208_) ? 10.0f : 5.0f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21827_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.16, 0.0));
        }
    }

    public void m_7023_(Vec3 speed) {
        if (this.m_6142_()) {
            this.m_19920_(this.m_6113_(), speed);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_7008_(true);
        return flyingPathNavigation;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (this.m_21824_()) {
            if (handStack.m_150930_(Items.f_42591_) && this.m_21223_() < this.m_21233_()) {
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                this.m_5634_(2.0f);
                if (player.m_150110_().f_35937_) return super.m_6071_(player, hand);
                handStack.m_41774_(1);
                return super.m_6071_(player, hand);
            }
            if (!this.m_21830_((LivingEntity)player)) return super.m_6071_(player, hand);
            if (this.f_19853_.m_5776_()) return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            Item item = handStack.m_41720_();
            if (item instanceof DragonflyArmorItem) {
                DragonflyArmorItem armorItem = (DragonflyArmorItem)item;
                if (this.getArmor().m_41619_()) {
                    this.m_21051_(Attributes.f_22276_).m_22100_((double)armorItem.getHealthBuff());
                    this.m_21153_(armorItem.getHealthBuff());
                    this.setArmor(handStack.m_41777_());
                    handStack.m_41774_(1);
                    if (!player.m_150110_().f_35937_) {
                        handStack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_11675_, 0.4f, 1.5f);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
                }
            }
            if (player.m_6047_() && !this.getArmor().m_41619_()) {
                this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
                this.m_21153_(8.0f);
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getArmor().m_41777_()));
                this.setArmor(ItemStack.f_41583_);
                this.m_5496_(SoundEvents.f_12019_, 0.2f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
            this.m_21839_(!this.m_21827_());
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (!handStack.m_150930_(Items.f_42591_)) return super.m_6071_(player, hand);
        if (!player.m_150110_().f_35937_) {
            handStack.m_41774_(1);
        }
        if (this.f_19853_.m_5776_()) return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        this.f_19853_.m_7605_((Entity)this, (byte)6);
        return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
    }

    public void m_7105_(boolean tame) {
        super.m_7105_(tame);
        if (tame) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
            this.m_21153_(8.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    public boolean m_6898_(ItemStack itemStack) {
        return false;
    }

    public boolean m_35506_() {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dragonfly_sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dragonfly_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public ItemStack getArmor() {
        return (ItemStack)this.f_19804_.m_135370_(ARMOR_ITEM);
    }

    public void setArmor(ItemStack armorItem) {
        this.f_19804_.m_135381_(ARMOR_ITEM, (Object)armorItem);
    }

    static class DragonflyMoveControl
    extends FlyingMoveControl {
        public DragonflyMoveControl(DragonflyEntity dragonfly) {
            super((Mob)dragonfly, 360, true);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_20242_(true);
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, 360.0f));
                float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                this.f_24974_.m_7910_(speed);
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                    float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, 20.0f));
                    this.f_24974_.m_21567_(d1 > 0.0 ? speed : -speed);
                }
            } else {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }

    static class FollowOwnerGoal
    extends net.minecraft.world.entity.ai.goal.FollowOwnerGoal {
        private final Level level;

        public FollowOwnerGoal(DragonflyEntity dragonfly, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
            super((TamableAnimal)dragonfly, speedModifier, startDistance, stopDistance, canFly);
            this.level = dragonfly.m_9236_();
        }

        protected boolean m_25307_(BlockPos blockPos) {
            return this.level.m_8055_(blockPos).m_60795_() || super.m_25307_(blockPos);
        }
    }

    public class RandomFlyGoal
    extends Goal {
        private BlockPos targetPosition;

        public RandomFlyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !DragonflyEntity.this.m_21827_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (!(this.targetPosition == null || DragonflyEntity.this.f_19853_.m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > DragonflyEntity.this.f_19853_.m_141937_())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || DragonflyEntity.this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)DragonflyEntity.this.m_20182_(), 2.0)) {
                Vec3 randomPos = RandomPos.m_148542_((PathfinderMob)DragonflyEntity.this, () -> new BlockPos(DragonflyEntity.this.m_20185_() + (double)DragonflyEntity.this.f_19796_.m_188503_(7) - (double)DragonflyEntity.this.f_19796_.m_188503_(7), DragonflyEntity.this.m_20186_() + (double)DragonflyEntity.this.f_19796_.m_188503_(6) - 2.0, DragonflyEntity.this.m_20189_() + (double)DragonflyEntity.this.f_19796_.m_188503_(7) - (double)DragonflyEntity.this.f_19796_.m_188503_(7)));
                this.targetPosition = randomPos == null ? DragonflyEntity.this.m_20183_() : new BlockPos(randomPos);
            }
            double d0 = (double)this.targetPosition.m_123341_() + 0.5 - DragonflyEntity.this.m_20185_();
            double d1 = (double)this.targetPosition.m_123342_() + 0.1 - DragonflyEntity.this.m_20186_();
            double d2 = (double)this.targetPosition.m_123343_() + 0.5 - DragonflyEntity.this.m_20189_();
            double speed = DragonflyEntity.this.m_21133_(Attributes.f_22280_);
            Vec3 deltaMovement = DragonflyEntity.this.m_20184_();
            Vec3 signumDeltaMovement = deltaMovement.m_82520_((Math.signum(d0) * 0.5 - deltaMovement.f_82479_) * speed, (Math.signum(d1) * (double)0.7f - deltaMovement.f_82480_) * speed, (Math.signum(d2) * 0.5 - deltaMovement.f_82481_) * speed);
            DragonflyEntity.this.m_20256_(signumDeltaMovement);
            float angle = (float)(Mth.m_14136_((double)signumDeltaMovement.f_82481_, (double)signumDeltaMovement.f_82479_) * 57.2957763671875) - 90.0f;
            float wrappedAngle = Mth.m_14177_((float)(angle - DragonflyEntity.this.m_146908_()));
            DragonflyEntity.this.f_20902_ = 0.5f;
            DragonflyEntity.this.m_146922_(DragonflyEntity.this.m_146908_() + wrappedAngle);
        }
    }
}

