/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.client.model.BubbleModel;
import com.github.eterdelta.crittersandcompanions.client.model.GrapplingHookModel;
import com.github.eterdelta.crittersandcompanions.client.renderer.BubbleLayer;
import com.github.eterdelta.crittersandcompanions.client.renderer.GrapplingHookRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.DragonflyRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.DumboOctopusRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.FerretRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.JumpingSpiderRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.KoiFishRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.LeafInsectRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.OtterRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.RedPandaRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.SeaBunnyRenderer;
import com.github.eterdelta.crittersandcompanions.client.renderer.geo.entity.ShimaEnagaRenderer;
import com.github.eterdelta.crittersandcompanions.entity.DragonflyEntity;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import com.github.eterdelta.crittersandcompanions.entity.JumpingSpiderEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.entity.LeafInsectEntity;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import com.github.eterdelta.crittersandcompanions.entity.RedPandaEntity;
import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import com.github.eterdelta.crittersandcompanions.entity.ShimaEnagaEntity;
import com.github.eterdelta.crittersandcompanions.handler.SpawnHandler;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="crittersandcompanions")
public class CrittersAndCompanions {
    public static final String MODID = "crittersandcompanions";
    public static final CreativeModeTab CREATIVE_TAB = new CreativeModeTab("crittersandcompanions"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)CACItems.PEARL_NECKLACE_1.get());
        }
    };

    public CrittersAndCompanions() {
        GeckoLib.initialize();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CACBlocks.BLOCKS.register(eventBus);
        CACEntities.ENTITIES.register(eventBus);
        CACItems.ITEMS.register(eventBus);
        CACSounds.SOUNDS.register(eventBus);
        eventBus.addListener(this::onSetup);
        eventBus.addListener(this::onAttributeCreation);
        eventBus.addListener(this::registerEntityRenderers);
        eventBus.addListener(this::registerEntityLayers);
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(this::addEntityLayers);
        }
        eventBus.addListener(this::gatherData);
        eventBus.addListener(this::onAddPackFinders);
    }

    public void gatherData(GatherDataEvent event) {
        SpawnHandler.datagenBiomeModifiers(event);
    }

    public void onAddPackFinders(AddPackFindersEvent event) {
        try {
            System.out.println("Hello");
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFile modFile = ModList.get().getModFileById(MODID).getFile();
                Path resourcePath = modFile.findResource(new String[]{"builtin/friendlyart"});
                PathPackResources pack = new PathPackResources(modFile.getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/crittersandcompanions", (Component)Component.m_237113_((String)"Friendly Critter Art"), false, () -> pack, metadataSection, Pack.Position.BOTTOM, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void onSetup(FMLCommonSetupEvent event) {
        CACPacketHandler.registerPackets();
        event.enqueueWork(() -> {
            SpawnHandler.registerSpawnPlacements();
            ItemProperties.register((Item)((Item)CACItems.DUMBO_OCTOPUS_BUCKET.get()), (ResourceLocation)new ResourceLocation("variant"), (stack, clientLevel, entity, seed) -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BucketVariant")) {
                    return stack.m_41783_().m_128451_("BucketVariant");
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Item)CACItems.SEA_BUNNY_BUCKET.get()), (ResourceLocation)new ResourceLocation("variant"), (stack, clientLevel, entity, seed) -> {
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("BucketVariant")) {
                    return stack.m_41783_().m_128451_("BucketVariant");
                }
                return 0.0f;
            });
        });
    }

    private void onAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)CACEntities.OTTER.get(), OtterEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.JUMPING_SPIDER.get(), JumpingSpiderEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.KOI_FISH.get(), KoiFishEntity.m_27495_().m_22265_());
        event.put((EntityType)CACEntities.DRAGONFLY.get(), DragonflyEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.SEA_BUNNY.get(), SeaBunnyEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.SHIMA_ENAGA.get(), ShimaEnagaEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.FERRET.get(), FerretEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.DUMBO_OCTOPUS.get(), DumboOctopusEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.LEAF_INSECT.get(), LeafInsectEntity.createAttributes().m_22265_());
        event.put((EntityType)CACEntities.RED_PANDA.get(), RedPandaEntity.createAttributes().m_22265_());
    }

    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CACEntities.OTTER.get(), OtterRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.JUMPING_SPIDER.get(), JumpingSpiderRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.KOI_FISH.get(), KoiFishRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.DRAGONFLY.get(), DragonflyRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.SEA_BUNNY.get(), SeaBunnyRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.SHIMA_ENAGA.get(), ShimaEnagaRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.FERRET.get(), FerretRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.GRAPPLING_HOOK.get(), GrapplingHookRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.DUMBO_OCTOPUS.get(), DumboOctopusRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.LEAF_INSECT.get(), LeafInsectRenderer::new);
        event.registerEntityRenderer((EntityType)CACEntities.RED_PANDA.get(), RedPandaRenderer::new);
    }

    public void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BubbleLayer.LAYER_LOCATION, BubbleModel::createLayer);
        event.registerLayerDefinition(GrapplingHookRenderer.LAYER_LOCATION, GrapplingHookModel::createLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addEntityLayers(EntityRenderersEvent.AddLayers event) {
        if (FMLEnvironment.dist.isClient()) {
            for (String skinName : event.getSkins()) {
                LivingEntityRenderer skinRenderer = event.getSkin(skinName);
                skinRenderer.m_115326_((RenderLayer)new BubbleLayer((RenderLayerParent<Player, PlayerModel<Player>>)skinRenderer, event.getEntityModels()));
            }
        }
    }
}

