/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.machines.tiles.nv.StoneBasicMachineTileEntity;
import ic2.core.block.machines.tiles.nv.StoneCannerTileEntity;
import ic2.core.block.machines.tiles.nv.StoneWoodGassifierTileEntity;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StoneMachineInfo
implements IInfoProvider {
    public static final StoneMachineInfo THIS = new StoneMachineInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof StoneBasicMachineTileEntity) {
            StoneBasicMachineTileEntity stoneMachine = (StoneBasicMachineTileEntity)blockEntity;
            if (stoneMachine.getFuel() > 0) {
                helper.bar(stoneMachine.getFuel(), stoneMachine.getMaxFuel(), (Component)Component.m_237115_((String)"ic2.probe.fuel.storage.name").m_130946_(String.valueOf(stoneMachine.getFuel())), ColorUtils.DARK_GRAY);
            }
            if (stoneMachine.getProgress() > 0.0f) {
                helper.bar((int)stoneMachine.getProgress(), (int)stoneMachine.getMaxProgress(), (Component)Component.m_237110_((String)"ic2.probe.progress.full.name", (Object[])new Object[]{(int)stoneMachine.getProgress(), (int)stoneMachine.getMaxProgress()}).m_130946_("t").m_130940_(ChatFormatting.WHITE), -16733185);
            }
        }
        if (blockEntity instanceof StoneWoodGassifierTileEntity) {
            StoneWoodGassifierTileEntity woodGassifierTile = (StoneWoodGassifierTileEntity)blockEntity;
            helper.defaultText("ic2.probe.pump.pressure", TextFormatter.GREEN.literal("25"));
            helper.defaultText("ic2.probe.pump.amount", TextFormatter.GREEN.literal(Formatters.EU_FORMAT.format(900L)));
            if (woodGassifierTile.getFuel() > 0) {
                helper.bar(woodGassifierTile.getFuel(), woodGassifierTile.getMaxFuel(), (Component)Component.m_237115_((String)"ic2.probe.fuel.storage.name").m_130946_(String.valueOf(woodGassifierTile.getFuel())), ColorUtils.DARK_GRAY);
            }
            if (woodGassifierTile.getProgress() > 0.0f) {
                helper.bar((int)woodGassifierTile.getProgress(), (int)woodGassifierTile.getMaxProgress(), (Component)Component.m_237110_((String)"ic2.probe.progress.full.name", (Object[])new Object[]{(int)woodGassifierTile.getProgress(), (int)woodGassifierTile.getMaxProgress()}).m_130946_("t").m_130940_(ChatFormatting.WHITE), -16733185);
            }
            helper.addTankInfo((BlockEntity)woodGassifierTile);
        }
        if (blockEntity instanceof StoneCannerTileEntity) {
            StoneCannerTileEntity stoneCannerTile = (StoneCannerTileEntity)blockEntity;
            if (stoneCannerTile.getFuel() > 0) {
                helper.bar(stoneCannerTile.getFuel(), stoneCannerTile.getMaxFuel(), (Component)Component.m_237115_((String)"ic2.probe.fuel.storage.name").m_130946_(String.valueOf(stoneCannerTile.getFuel())), ColorUtils.DARK_GRAY);
            }
            if (stoneCannerTile.getProgress() > 0.0f) {
                helper.bar((int)stoneCannerTile.getProgress(), (int)stoneCannerTile.getMaxProgress(), (Component)Component.m_237110_((String)"ic2.probe.progress.full.name", (Object[])new Object[]{(int)stoneCannerTile.getProgress(), (int)stoneCannerTile.getMaxProgress()}).m_130946_("t").m_130940_(ChatFormatting.WHITE), -16733185);
            }
        }
    }
}

