/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.machines.tiles.hv.RocketMinerTileEntity;
import ic2.core.block.machines.tiles.lv.MinerTileEntity;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MinerInfo
implements IInfoProvider {
    public static final MinerInfo THIS = new MinerInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof MinerTileEntity) {
            MinerTileEntity miner = (MinerTileEntity)blockEntity;
            helper.maxIn(miner.getMaxInput());
            helper.usage(miner.getEnergyUsage());
            float progress = miner.getProgress();
            boolean isStuck = miner.isStuck();
            boolean isOperating = miner.isOperating();
            if (miner instanceof RocketMinerTileEntity) {
                RocketMinerTileEntity rocketMiner = (RocketMinerTileEntity)miner;
                RocketMinerTileEntity.MinerState state = rocketMiner.state;
                helper.defaultText((Component)state.getState());
                helper.addTankInfo((BlockEntity)rocketMiner);
            } else {
                helper.defaultText(isStuck ? "ic2.probe.miner.stuck.name" : (isOperating ? "ic2.probe.miner.mining.name" : "ic2.probe.miner.retracting.name"), new Object[0]);
            }
            helper.text((Component)this.translate("ic2.probe.miner.progress.name", new Object[]{miner.getPipeTip().m_123342_()}).m_130940_(ChatFormatting.GOLD));
            if (!isStuck && progress > 0.0f) {
                int scaledOp = (int)Math.min(6.0E7f, progress);
                int scaledMaxOp = (int)Math.min(6.0E7f, miner.getMaxProgress());
                helper.bar(scaledOp, scaledMaxOp, (Component)this.translate("ic2.probe.progress.full.name", new Object[]{scaledOp, scaledMaxOp}), -16733185);
            }
        }
    }
}

