/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.energy.tile.IEnergySink;
import ic2.core.block.base.tiles.impls.BaseCropLibraryTileEntity;
import ic2.core.block.machines.tiles.ev.UUCropLibraryTileEntity;
import ic2.core.utils.helpers.StackUtil;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CropLibraryInfo
implements IInfoProvider {
    public static final CropLibraryInfo THIS = new CropLibraryInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseCropLibraryTileEntity) {
            List stackList;
            BaseCropLibraryTileEntity baseCropLibrary = (BaseCropLibraryTileEntity)blockEntity;
            if (baseCropLibrary instanceof IEnergySink) {
                IEnergySink sink = (IEnergySink)baseCropLibrary;
                helper.maxInFromTier(sink.getSinkTier());
                helper.usage(1);
            }
            if (baseCropLibrary instanceof UUCropLibraryTileEntity) {
                UUCropLibraryTileEntity uum = (UUCropLibraryTileEntity)baseCropLibrary;
                helper.bar(uum.uu_matter, 512, (Component)this.string("UU Matter: " + uum.uu_matter + " / 512"), -5829955);
            }
            int cropCount = baseCropLibrary.syncer.getCropCount();
            int statCount = baseCropLibrary.syncer.getStatCount();
            int sizeLimit = baseCropLibrary.storage.getSizeLimit();
            int typeLimit = baseCropLibrary.storage.getTypeLimit();
            int statLimit = baseCropLibrary.storage.getStatLimit();
            if (typeLimit != -1) {
                helper.defaultText("ic2.probe.crop_library.type.name", cropCount, typeLimit);
                helper.defaultText("ic2.probe.crop_library.stat.name", statCount, statLimit * typeLimit);
                helper.defaultText("ic2.probe.crop_library.size.name", sizeLimit);
            }
            if (!(stackList = StackUtil.copyNonEmpty((List)baseCropLibrary.storage.getTypes())).isEmpty()) {
                helper.grid(stackList, (Component)this.translate("ic2.probe.crop_library.name").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

