/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.crops.ICrop;
import ic2.api.crops.ICropRegistry;
import ic2.api.crops.ICropTile;
import ic2.api.crops.ISeedCrop;
import ic2.core.inventory.filter.IFilter;
import ic2.core.platform.registries.IC2Items;
import ic2.core.utils.math.ColorUtils;
import ic2.core.utils.tooltips.ILangHelper;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.config.WailaConfig;

public class CropInfo
implements IInfoProvider {
    public static final CropInfo THIS = new CropInfo();

    @Override
    public IFilter getFilter() {
        return CROP_ANALYZER;
    }

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof ICropTile) {
            ICropTile tile = (ICropTile)blockEntity;
            ICrop crop = tile.getCrop();
            int fertilizer = tile.getFertilizerStorage();
            int water = tile.getWaterStorage();
            int weedex = tile.getWeedExStorage();
            int nutrients = tile.getNutrients();
            int humidity = tile.getHumidity();
            int env = tile.getEnvironmentQuality();
            int light = tile.getLightLevel();
            if (crop != null) {
                int maxStage = crop.getGrowthSteps();
                int currentStage = tile.getGrowthStage();
                int scanLevel = tile.getScanLevel();
                int growthSpeed = tile.calculateGrowthSpeed();
                int points = tile.getGrowthPoints();
                int maxPoints = crop.getGrowthDuration(tile);
                int growth = tile.getGrowthStat();
                int gain = tile.getGainStat();
                int resistance = tile.getResistanceStat();
                boolean canGrow = crop.canGrow(tile);
                boolean waterLogCompat = crop.getCropType().isCompatible(tile.isWaterLogged());
                if (scanLevel < 4 && currentStage < maxStage) {
                    helper.bar(scanLevel, 4, (Component)this.translate("ic2.probe.crop.info.scan", new Object[]{scanLevel, 4}), ColorUtils.GREEN);
                } else {
                    helper.centered((Component)this.translate("ic2.probe.crop.growth").m_130940_(ChatFormatting.YELLOW));
                    if (currentStage < maxStage) {
                        helper.bar(currentStage, maxStage, (Component)this.translate("ic2.probe.crop.info.stage", new Object[]{currentStage, maxStage}), ColorUtils.GREEN);
                        helper.bar(points, maxPoints, (Component)this.translate("ic2.probe.crop.info.points", new Object[]{points, maxPoints}), ColorUtils.GREEN);
                        if (canGrow && waterLogCompat) {
                            helper.centered((Component)this.translate("ic2.probe.crop.grow.rate", new Object[]{growthSpeed}).m_130940_(ChatFormatting.GOLD));
                        } else {
                            helper.centered((Component)this.translate("ic2.probe.crop.grow.not").m_130940_(ChatFormatting.RED));
                        }
                    } else {
                        helper.bar(currentStage, maxStage, (Component)this.translate("ic2.probe.crop.info.stage_done"), ColorUtils.GREEN);
                    }
                    if (scanLevel >= 4) {
                        helper.centered((Component)this.translate("ic2.probe.crop.stats").m_130940_(ChatFormatting.YELLOW));
                        helper.bar(growth, 31, (Component)this.translate("ic2.probe.crop.info.growth", new Object[]{growth, 31}), ColorUtils.CYAN);
                        helper.bar(gain, 31, (Component)this.translate("ic2.probe.crop.info.gain", new Object[]{gain, 31}), -5829955);
                        helper.bar(resistance, 31, (Component)this.translate("ic2.probe.crop.info.resistance", new Object[]{resistance, 31}), ColorUtils.rgb((int)255, (int)170, (int)0));
                        int stress = (crop.getProperties().getTier() - 1) * 4 + growth + gain + resistance;
                        int maxStress = crop.getStatInfluence(tile, humidity, nutrients, env) * 5;
                        helper.bar(stress, maxStress, (Component)this.translate("ic2.probe.crop.info.needs", new Object[]{stress, maxStress}), ColorUtils.CYAN);
                    }
                }
                if (crop instanceof ISeedCrop) {
                    ISeedCrop seedCrop = (ISeedCrop)crop;
                    boolean isDroppingSeed = seedCrop.isDroppingSeeds(tile);
                    helper.text((Component)this.translate("ic2.probe.crop.seed_drop", new Object[]{(isDroppingSeed ? ChatFormatting.GREEN : ChatFormatting.RED) + String.valueOf(isDroppingSeed)}).m_130940_(ChatFormatting.GOLD));
                }
            }
            helper.centered((Component)this.translate("ic2.probe.crop.storage").m_130940_(ChatFormatting.YELLOW));
            helper.bar(fertilizer, 300, (Component)this.translate("ic2.probe.crop.info.fertilizer", new Object[]{fertilizer, 300}), ColorUtils.rgb((int)86, (int)54, (int)36));
            helper.bar(water, 200, (Component)this.translate("ic2.probe.crop.info.water", new Object[]{water, 200}), ColorUtils.rgb((int)93, (int)105, (int)255));
            helper.bar(weedex, 150, (Component)this.translate("ic2.probe.crop.info.weedex", new Object[]{weedex, 150}), ColorUtils.rgb((int)255, (int)85, (int)255));
            helper.centered((Component)this.translate("ic2.probe.crop.env").m_130940_(ChatFormatting.YELLOW));
            helper.bar(nutrients, 20, (Component)this.translate("ic2.probe.crop.info.nutrients", new Object[]{nutrients, 20}), ColorUtils.rgb((int)0, (int)255, (int)5));
            helper.bar(humidity, 20, (Component)this.translate("ic2.probe.crop.info.humidity", new Object[]{humidity, 20}), ColorUtils.rgb((int)93, (int)105, (int)255));
            helper.bar(env, 10, (Component)this.translate("ic2.probe.crop.info.env", new Object[]{env, 10}), ColorUtils.CYAN);
            helper.bar(light, 15, (Component)this.translate("ic2.probe.crop.info.light", new Object[]{light, 15}), ColorUtils.rgb((int)255, (int)255, (int)85));
        }
    }

    public static class CropIcon
    implements IBlockComponentProvider,
    IServerDataProvider<BlockEntity>,
    ILangHelper {
        public static final CropIcon THIS = new CropIcon();

        @Nullable
        public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
            ItemStack iconStack = ItemStack.f_41583_;
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof ICropTile) {
                ICropTile cropTile = (ICropTile)blockEntity;
                CompoundTag tag = accessor.getServerData().m_128469_("CropInfo");
                int maxStage = tag.m_128451_("growthSteps");
                int currentStage = tag.m_128451_("growthStage");
                int scanLevel = tag.m_128451_("scanLevel");
                if (cropTile.getCrop() != null) {
                    boolean condition = scanLevel < 1 && currentStage < maxStage && cropTile.getCrop() != ICropRegistry.WEED && cropTile.getCrop() != ICropRegistry.SEA_WEED;
                    iconStack = condition ? IC2Items.CROP_SEED.m_7968_() : cropTile.getCrop().getDisplayItem();
                }
            }
            return IElementHelper.get().item(iconStack);
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            CompoundTag tag = blockAccessor.getServerData().m_128469_("CropInfo");
            BlockEntity blockEntity = blockAccessor.getBlockEntity();
            if (blockEntity instanceof ICropTile) {
                ICropTile tile = (ICropTile)blockEntity;
                int maxStage = tag.m_128451_("growthSteps");
                int currentStage = tag.m_128451_("growthStage");
                int scanLevel = tag.m_128451_("scanLevel");
                ICrop crop = tile.getCrop();
                if (crop != null) {
                    List elements = HarvestToolProvider.INSTANCE.getText(blockAccessor, iPluginConfig, iTooltip.getElementHelper());
                    iTooltip.remove(Identifiers.MC_HARVEST_TOOL);
                    iTooltip.remove(Identifiers.CORE_OBJECT_NAME);
                    if (scanLevel < 1 && currentStage < maxStage && crop != ICropRegistry.WEED && crop != ICropRegistry.SEA_WEED) {
                        iTooltip.add(0, (Component)this.translate("info.crop.ic2.data.unknown").m_130940_(ChatFormatting.WHITE));
                        elements.forEach(element -> iTooltip.append(0, element.align(IElement.Align.RIGHT)));
                    } else {
                        iTooltip.add(0, ((WailaConfig)Jade.CONFIG.get()).getFormatting().title((Object)crop.getName()), Identifiers.CORE_OBJECT_NAME);
                        elements.forEach(element -> iTooltip.append(0, element.align(IElement.Align.RIGHT)));
                        iTooltip.add(1, iTooltip.getElementHelper().text((Component)this.translate("jei.ic2.reactor.by", new Object[]{crop.discoveredBy().m_6881_().m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.WHITE)));
                    }
                }
            }
        }

        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
            if (blockEntity instanceof ICropTile) {
                ICropTile tile = (ICropTile)blockEntity;
                CompoundTag tag = new CompoundTag();
                ICrop crop = tile.getCrop();
                if (crop != null) {
                    tag.m_128405_("growthSteps", crop.getGrowthSteps());
                    tag.m_128405_("growthStage", tile.getGrowthStage());
                    tag.m_128405_("scanLevel", tile.getScanLevel());
                }
                compoundTag.m_128365_("CropInfo", (Tag)tag);
            }
        }

        public ResourceLocation getUid() {
            return JadeTags.INFO_RENDERER;
        }
    }
}

