/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.energy.tile.IEnergyTile;
import ic2.core.block.cables.CableBlock;
import ic2.core.block.cables.CableTileEntity;
import ic2.core.utils.helpers.Formatters;
import ic2.core.utils.tooltips.ILangHelper;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.base.removals.ModNameRender;
import ic2.jadeplugin.helpers.EnergyContainer;
import ic2.jadeplugin.helpers.TextFormatter;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.util.ModIdentification;

public class CableInfo
implements IInfoProvider {
    public static final CableInfo THIS = new CableInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof CableTileEntity) {
            CableTileEntity cable = (CableTileEntity)blockEntity;
            int maxCap = cable.getConductorBreakdownEnergy() - 1;
            helper.tierFromPower(maxCap);
            helper.defaultText("tooltip.item.ic2.eu_reader.cable_limit", TextFormatter.GREEN.literal("" + maxCap));
            helper.defaultText("tooltip.item.ic2.eu_reader.cable_loss", TextFormatter.GREEN.literal(Formatters.CABLE_LOSS_FORMAT.format(cable.getConductionLoss())));
            EnergyContainer container = EnergyContainer.getContainer((IEnergyTile)cable);
            helper.addCableAverages(container.getAverageOut(), container.getPacketsOut());
        }
    }

    public static class CableIconProvider
    implements IBlockComponentProvider,
    ILangHelper {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            Block block = blockAccessor.getBlock();
            if (block instanceof CableBlock) {
                boolean foamed;
                CableBlock cableBlock = (CableBlock)block;
                BlockState state = blockAccessor.getBlockState();
                boolean bl = foamed = (Integer)state.m_61143_((Property)CableBlock.FOAMED) == 2;
                if (foamed) {
                    List elements = HarvestToolProvider.INSTANCE.getText(blockAccessor, iPluginConfig, iTooltip.getElementHelper());
                    ItemStack fakeStack = cableBlock.getCloneItemStack(state, blockAccessor.getHitResult(), (BlockGetter)blockAccessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getPlayer());
                    iTooltip.remove(Identifiers.MC_HARVEST_TOOL);
                    iTooltip.remove(Identifiers.CORE_OBJECT_NAME);
                    MutableComponent fakeNameComponent = fakeStack.m_41786_().m_6881_().m_130940_(ChatFormatting.WHITE);
                    TextElement textElement = new TextElement((Component)fakeNameComponent);
                    float f = Minecraft.m_91087_().f_91062_.m_92895_(fakeNameComponent.getString()) + 15;
                    Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                    iTooltip.add(0, textElement.size(new Vec2(f, 9.0f)));
                    elements.forEach(element -> iTooltip.append(0, element.align(IElement.Align.RIGHT)));
                    String fakeModName = ModIdentification.getModName((ItemStack)fakeStack);
                    String fakeModNameFormatted = String.format(((WailaConfig)Jade.CONFIG.get()).getFormatting().getModName(), fakeModName);
                    iTooltip.add((Component)this.string(fakeModNameFormatted));
                    iTooltip.remove(ModNameRender.RELOCATE);
                }
            }
        }

        public ResourceLocation getUid() {
            return JadeTags.INFO_RENDERER;
        }
    }
}

