/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.helpers;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum TextFormatter {
    BLACK(ChatFormatting.BLACK),
    DARK_BLUE(ChatFormatting.DARK_BLUE),
    DARK_GREEN(ChatFormatting.DARK_GREEN),
    DARK_AQUA(ChatFormatting.DARK_AQUA),
    DARK_RED(ChatFormatting.DARK_RED),
    DARK_PURPLE(ChatFormatting.DARK_PURPLE),
    GOLD(ChatFormatting.GOLD),
    GRAY(ChatFormatting.GRAY),
    DARK_GRAY(ChatFormatting.DARK_GRAY),
    BLUE(ChatFormatting.BLUE),
    GREEN(ChatFormatting.GREEN),
    AQUA(ChatFormatting.AQUA),
    RED(ChatFormatting.RED),
    LIGHT_PURPLE(ChatFormatting.LIGHT_PURPLE),
    YELLOW(ChatFormatting.YELLOW),
    WHITE(ChatFormatting.WHITE),
    OBFUSCATED(ChatFormatting.OBFUSCATED),
    BOLD(ChatFormatting.BOLD),
    STRIKETHROUGH(ChatFormatting.STRIKETHROUGH),
    UNDERLINE(ChatFormatting.UNDERLINE),
    ITALIC(ChatFormatting.ITALIC);

    final ChatFormatting FORMAT;
    public static final TextFormatter[] VALUES;

    private TextFormatter(ChatFormatting formatting) {
        this.FORMAT = formatting;
    }

    public MutableComponent translate(String translatable) {
        return Component.m_237115_((String)translatable).m_130940_(this.FORMAT);
    }

    public MutableComponent translate(String translatable, Object ... args) {
        return Component.m_237110_((String)translatable, (Object[])args).m_130940_(this.FORMAT);
    }

    public MutableComponent literal(String literal) {
        return Component.m_237113_((String)literal).m_130940_(this.FORMAT);
    }

    public MutableComponent component(Component component) {
        return component.m_6881_().m_130940_(this.FORMAT);
    }

    public static TextFormatter formatPercentage(int dropChance) {
        if (dropChance >= 90) {
            return GREEN;
        }
        if (dropChance > 75) {
            return YELLOW;
        }
        if (dropChance > 50) {
            return GOLD;
        }
        if (dropChance > 35) {
            return RED;
        }
        return DARK_RED;
    }

    public static TextFormatter getColor(int index) {
        return switch (index) {
            case 0 -> AQUA;
            case 1 -> RED;
            case 2 -> YELLOW;
            case 3 -> BLUE;
            case 4 -> LIGHT_PURPLE;
            case 5 -> GREEN;
            default -> WHITE;
        };
    }

    public static TextFormatter tier(int tier) {
        return switch (tier) {
            case 0 -> DARK_GRAY;
            case 1 -> GRAY;
            case 2 -> AQUA;
            case 3 -> GOLD;
            case 4 -> DARK_PURPLE;
            case 5 -> BLUE;
            case 6 -> LIGHT_PURPLE;
            case 7 -> RED;
            case 8 -> DARK_AQUA;
            default -> VALUES[tier];
        };
    }

    static {
        VALUES = TextFormatter.values();
    }
}

