/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.overlay.DisplayHelper;

public class CustomBoxElement
extends Element {
    IBoxStyle BOX;
    List<ItemStack> STACKS;
    int ROW_SIZE;

    public CustomBoxElement(IBoxStyle box, List<ItemStack> stacks, int rowSize) {
        this.BOX = box;
        this.STACKS = stacks;
        this.ROW_SIZE = rowSize;
    }

    public Vec2 getSize() {
        if (this.STACKS.isEmpty()) {
            return Vec2.f_82462_;
        }
        int columns = this.ROW_SIZE;
        int rows = (int)Math.ceil((double)this.STACKS.size() / (double)columns);
        int width = 18 * Math.min(this.STACKS.size(), columns) + 2;
        int height = 18 * rows + 2;
        return new Vec2((float)width, (float)height);
    }

    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        if (this.STACKS.isEmpty()) {
            return;
        }
        RenderSystem.m_69478_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        Vec2 size = this.getSize();
        float width = size.f_82470_;
        float height = size.f_82471_;
        this.BOX.render(matrixStack, 0.0f, 0.0f, width, height - 2.0f);
        int rowSize = this.ROW_SIZE;
        for (int index = 0; index < this.STACKS.size(); ++index) {
            int xPos = index % rowSize * 18;
            int yPos = index / rowSize * 18;
            ItemStack stack = this.STACKS.get(index);
            DisplayHelper.INSTANCE.drawItem(matrixStack, (float)(1 + xPos), (float)(1 + yPos), stack, 1.0f, null);
        }
        matrixStack.m_85849_();
    }
}

