/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.base.removals;

import ic2.core.block.base.IToolProvider;
import ic2.jadeplugin.IC2JadePlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.ModIdentification;

public class ModNameRender {
    public static final ResourceLocation REMOVER = IC2JadePlugin.rl("remove_modid");
    public static final ResourceLocation RELOCATE = IC2JadePlugin.rl("relocate_modid");
    public static final ModNameRelocator MOD_NAME_REMOVER = new ModNameRelocator(REMOVER, 10000);
    public static final ModNameRelocator MOD_NAME_RELOCATOR = new ModNameRelocator(RELOCATE, -10000);

    public static class ModNameRelocator
    implements IBlockComponentProvider {
        ResourceLocation ID;
        int PRIORITY;

        public ModNameRelocator(ResourceLocation id, int priority) {
            this.ID = id;
            this.PRIORITY = priority;
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            if (blockAccessor.getBlock() instanceof IToolProvider) {
                String MOD_NAME = ModIdentification.getModName((Block)blockAccessor.getBlock());
                if (ModIdentification.getModName((Block)blockAccessor.getBlock()).equals(MOD_NAME)) {
                    if (this.getUid() == REMOVER) {
                        iTooltip.remove(Identifiers.CORE_MOD_NAME);
                    } else if (this.getUid() == RELOCATE) {
                        String modName = String.format(((WailaConfig)Jade.CONFIG.get()).getFormatting().getModName(), MOD_NAME);
                        iTooltip.add((Component)Component.m_237113_((String)modName));
                    }
                }
            }
        }

        public ResourceLocation getUid() {
            return this.ID;
        }

        public int getDefaultPriority() {
            return this.PRIORITY;
        }
    }
}

