/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.base.elements;

import ic2.jadeplugin.base.elements.CommonElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class CommonBoxElement
extends CommonElement {
    List<ItemStack> GRID_STACKS;
    int SIZE;

    public CommonBoxElement(List<ItemStack> gridStacks, int size) {
        super(Vec2.f_82462_, "LEFT");
        this.GRID_STACKS = gridStacks;
        this.SIZE = size;
    }

    public List<ItemStack> getGridStacks() {
        return this.GRID_STACKS;
    }

    public int getSize() {
        return this.SIZE;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ItemStack stack : this.GRID_STACKS) {
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128365_("stack", (Tag)stack.m_41739_(new CompoundTag()));
            stackTag.m_128405_("count", stack.m_41613_());
            list.add((Object)stackTag);
        }
        if (!list.isEmpty()) {
            tag.m_128365_("GridStacks", (Tag)list);
        }
        tag.m_128405_("size", this.SIZE);
        return tag;
    }

    public static CommonBoxElement load(CompoundTag tag) {
        ObjectArrayList gridStacks = new ObjectArrayList();
        ListTag list = tag.m_128437_("GridStacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("stack"));
            int count = stackTag.m_128451_("count");
            stack.m_41764_(count);
            gridStacks.add(stack);
        }
        int size = tag.m_128451_("size");
        return new CommonBoxElement((List<ItemStack>)gridStacks, size);
    }

    @Override
    public String getTagId() {
        return "jade_addon_box";
    }
}

