/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.cannon;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.item.BeltConnectorItem;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class LaunchedItem {
    public int totalTicks;
    public int ticksRemaining;
    public BlockPos target;
    public ItemStack stack;

    private LaunchedItem(BlockPos start, BlockPos target, ItemStack stack) {
        this(target, stack, LaunchedItem.ticksForDistance(start, target), LaunchedItem.ticksForDistance(start, target));
    }

    private static int ticksForDistance(BlockPos start, BlockPos target) {
        return (int)Math.max(10.0, Math.sqrt(Math.sqrt(target.m_123331_((Vec3i)start))) * 4.0);
    }

    LaunchedItem() {
    }

    private LaunchedItem(BlockPos target, ItemStack stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(Level world) {
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return false;
        }
        if (world.f_46443_) {
            return false;
        }
        this.place(world);
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag c = new CompoundTag();
        c.m_128405_("TotalTicks", this.totalTicks);
        c.m_128405_("TicksLeft", this.ticksRemaining);
        c.m_128365_("Stack", (Tag)this.stack.serializeNBT());
        c.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
        return c;
    }

    public static LaunchedItem fromNBT(CompoundTag c) {
        ForBelt launched = c.m_128441_("Length") ? new ForBelt() : (c.m_128441_("BlockState") ? new ForBlockState() : new ForEntity());
        ((LaunchedItem)launched).readNBT(c);
        return launched;
    }

    abstract void place(Level var1);

    void readNBT(CompoundTag c) {
        this.target = NbtUtils.m_129239_((CompoundTag)c.m_128469_("Target"));
        this.ticksRemaining = c.m_128451_("TicksLeft");
        this.totalTicks = c.m_128451_("TotalTicks");
        this.stack = ItemStack.m_41712_((CompoundTag)c.m_128469_("Stack"));
    }

    public static class ForBelt
    extends ForBlockState {
        public int length;
        public BeltBlockEntity.CasingType[] casings;

        public ForBelt() {
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag serializeNBT = super.serializeNBT();
            serializeNBT.m_128405_("Length", this.length);
            serializeNBT.m_128408_("Casing", Arrays.stream(this.casings).map(Enum::ordinal).toList());
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundTag nbt) {
            this.length = nbt.m_128451_("Length");
            int[] intArray = nbt.m_128465_("Casing");
            this.casings = new BeltBlockEntity.CasingType[this.length];
            for (int i = 0; i < this.casings.length; ++i) {
                this.casings[i] = i >= intArray.length ? BeltBlockEntity.CasingType.NONE : BeltBlockEntity.CasingType.values()[Mth.m_14045_((int)intArray[i], (int)0, (int)(BeltBlockEntity.CasingType.values().length - 1))];
            }
            super.readNBT(nbt);
        }

        public ForBelt(BlockPos start, BlockPos target, ItemStack stack, BlockState state, BeltBlockEntity.CasingType[] casings) {
            super(start, target, stack, state, null);
            this.casings = casings;
            this.length = casings.length;
        }

        @Override
        void place(Level world) {
            boolean isStart = this.state.m_61143_(BeltBlock.PART) == BeltPart.START;
            BlockPos offset = BeltBlock.nextSegmentPosition(this.state, BlockPos.f_121853_, isStart);
            int i = this.length - 1;
            Direction.Axis axis = this.state.m_61143_(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS ? Direction.Axis.Y : ((Direction)this.state.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122427_().m_122434_();
            world.m_46597_(this.target, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)AbstractSimpleShaftBlock.AXIS, (Comparable)axis));
            BeltConnectorItem.createBelts(world, this.target, this.target.m_7918_(offset.m_123341_() * i, offset.m_123342_() * i, offset.m_123343_() * i));
            for (int segment = 0; segment < this.length; ++segment) {
                BlockPos casingTarget;
                BlockEntity blockEntity;
                if (this.casings[segment] == BeltBlockEntity.CasingType.NONE || !((blockEntity = world.m_7702_(casingTarget = this.target.m_7918_(offset.m_123341_() * segment, offset.m_123342_() * segment, offset.m_123343_() * segment))) instanceof BeltBlockEntity)) continue;
                BeltBlockEntity bbe = (BeltBlockEntity)blockEntity;
                bbe.setCasingType(this.casings[segment]);
            }
        }
    }

    public static class ForBlockState
    extends LaunchedItem {
        public BlockState state;
        public CompoundTag data;

        ForBlockState() {
        }

        public ForBlockState(BlockPos start, BlockPos target, ItemStack stack, BlockState state, CompoundTag data) {
            super(start, target, stack);
            this.state = state;
            this.data = data;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag serializeNBT = super.serializeNBT();
            serializeNBT.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.state));
            if (this.data != null) {
                this.data.m_128473_("x");
                this.data.m_128473_("y");
                this.data.m_128473_("z");
                this.data.m_128473_("id");
                serializeNBT.m_128365_("Data", (Tag)this.data);
            }
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundTag nbt) {
            super.readNBT(nbt);
            this.state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("BlockState"));
            if (nbt.m_128425_("Data", 10)) {
                this.data = nbt.m_128469_("Data");
            }
        }

        @Override
        void place(Level world) {
            BlockHelper.placeSchematicBlock(world, this.state, this.target, this.stack, this.data);
        }
    }

    public static class ForEntity
    extends LaunchedItem {
        public Entity entity;
        private CompoundTag deferredTag;

        ForEntity() {
        }

        public ForEntity(BlockPos start, BlockPos target, ItemStack stack, Entity entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        @Override
        public boolean update(Level world) {
            if (this.deferredTag != null && this.entity == null) {
                try {
                    Optional loadEntityUnchecked = EntityType.m_20642_((CompoundTag)this.deferredTag, (Level)world);
                    if (!loadEntityUnchecked.isPresent()) {
                        return true;
                    }
                    this.entity = (Entity)loadEntityUnchecked.get();
                }
                catch (Exception var3) {
                    return true;
                }
                this.deferredTag = null;
            }
            return super.update(world);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag serializeNBT = super.serializeNBT();
            if (this.entity != null) {
                serializeNBT.m_128365_("Entity", (Tag)this.entity.serializeNBT());
            }
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundTag nbt) {
            super.readNBT(nbt);
            if (nbt.m_128441_("Entity")) {
                this.deferredTag = nbt.m_128469_("Entity");
            }
        }

        @Override
        void place(Level world) {
            if (this.entity != null) {
                world.m_7967_(this.entity);
            }
        }
    }
}

