/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.SawRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.m_61143_((Property)SawBlock.FACING)).m_122424_());
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)SawBlock.FACING)).m_122436_()).m_82490_((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)SawBlock.FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        if (closestToFacing.m_122434_().m_122478_() && context.data.m_128441_("BreakingPos")) {
            context.data.m_128473_("BreakingPos");
            context.stall = false;
        }
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        return super.canBreak(world, breakingPos, state) && SawBlockEntity.isSawable(state);
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (brokenState.m_204336_(BlockTags.f_13035_)) {
            return;
        }
        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(brokenState.m_60734_(), pos);
        if (dynamicTree.isPresent()) {
            dynamicTree.get().destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (BlockPos)stack, (ItemStack)dropPos));
            return;
        }
        TreeCutter.findTree((BlockGetter)context.world, pos, brokenState).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (BlockPos)stack, (ItemStack)dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, BlockPos pos, ItemStack stack) {
        ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)context.contraption.getSharedInventory(), (ItemStack)stack, (boolean)false);
        if (remainder.m_41619_()) {
            return;
        }
        Level world = context.world;
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        float distance = context.position == null ? 1.0f : (float)dropPos.m_82554_(context.position);
        ItemEntity entity = new ItemEntity(world, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, remainder);
        entity.m_20256_(context.relativeMotion.m_82490_((double)(distance / 20.0f)));
        world.m_7967_((Entity)entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        SawRenderer.renderInContraption(context, renderWorld, matrices, buffer);
    }

    @Override
    protected boolean shouldDestroyStartBlock(BlockState stateToBreak) {
        return !TreeCutter.canDynamicTreeCutFrom(stateToBreak.m_60734_());
    }

    @Override
    protected DamageSource getDamageSource() {
        return SawBlock.damageSourceSaw;
    }
}

