/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static final Style GRAY_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    public static final Component INVENTORY_TEXT = Utils.localize("container.inventory", new Object[0]);

    public static String removeLastChar(String line) {
        if (line == null || line.isEmpty()) {
            return "";
        }
        return line.substring(0, line.length() - 1);
    }

    public static Component getFormattedCoordinates(BlockPos pos) {
        return Component.m_237110_((String)"messages.securitycraft:formattedCoordinates", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public static MutableComponent localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            Component component;
            Object object = params[i];
            if (object instanceof Component && (object = (component = (Component)object).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents translatableContents = (TranslatableContents)object;
                params[i] = Utils.localize(translatableContents.m_237508_(), translatableContents.m_237523_());
                continue;
            }
            object = params[i];
            if (!(object instanceof BlockPos)) continue;
            BlockPos pos = (BlockPos)object;
            params[i] = Utils.getFormattedCoordinates(pos);
        }
        return Component.m_237110_((String)key, (Object[])params);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Potion potion) {
        return ForgeRegistries.POTIONS.getKey((Object)potion);
    }
}

