/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.fruitsdelight.init.plants.FDTreeType;
import dev.xkmc.fruitsdelight.init.plants.FruitPlant;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.repack.registrate.builders.BlockBuilder;
import dev.xkmc.l2library.repack.registrate.builders.ItemBuilder;
import dev.xkmc.l2library.repack.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.l2library.repack.registrate.util.entry.BlockEntry;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.util.Lazy;

public enum FDTrees implements FruitPlant<FDTrees>
{
    PEAR(() -> Blocks.f_50001_, FDTreeType.TALL, 3, 0.3f, false, 15),
    HAWBERRY(() -> Blocks.f_50000_, FDTreeType.TALL, 2, 0.3f, true, 20),
    LYCHEE(() -> Blocks.f_50002_, FDTreeType.TALL, 2, 0.3f, true, 4),
    MANGO(() -> Blocks.f_50002_, FDTreeType.NORMAL, 3, 0.3f, false, 4),
    PERSIMMON(() -> Blocks.f_50000_, FDTreeType.FANCY, 3, 0.3f, false, 50),
    PEACH(() -> Blocks.f_50002_, FDTreeType.PEACH, 3, 0.3f, false, 8),
    ORANGE(() -> Blocks.f_49999_, FDTreeType.NORMAL, 3, 0.3f, false, 20),
    APPLE(() -> Blocks.f_49999_, FDTreeType.NORMAL, str -> () -> Items.f_42410_, 20),
    MANGOSTEEN(() -> Blocks.f_49999_, FDTreeType.FANCY, 3, 0.3f, false, 40),
    BAYBERRY(() -> Blocks.f_50000_, FDTreeType.TALL, 2, 0.3f, true, 15),
    KIWI(() -> Blocks.f_50002_, FDTreeType.NORMAL, 3, 0.3f, true, 20),
    FIG(() -> Blocks.f_49999_, FDTreeType.NORMAL, 3, 0.3f, false, 20),
    DURIAN(() -> Blocks.f_50002_, FDTreeType.DURIAN, Durian::buildItem, 200);

    private final BlockEntry<? extends BaseLeavesBlock> leaves;
    private final BlockEntry<SaplingBlock> sapling;
    private final Supplier<Item> fruit;
    private final BlockEntry<FlowerPotBlock> pot;
    private final Lazy<TreeConfiguration> treeConfig;
    private final Lazy<TreeConfiguration> treeConfigWild;
    public final ResourceLocation configKey;
    public final ResourceLocation configKeyWild;
    public final ResourceLocation placementKey;
    public final Supplier<Block> log;
    private final int spawn;
    public boolean genTree = false;
    private Holder<ConfiguredFeature<TreeConfiguration, ?>> treeCF;
    private Holder<ConfiguredFeature<TreeConfiguration, ?>> wildCF;
    private Holder<PlacedFeature> wildPF;

    private FDTrees(Supplier<Block> log, FDTreeType height, Function<String, Supplier<Item>> items, int spawn) {
        this.spawn = spawn;
        String name = this.name().toLowerCase(Locale.ROOT);
        this.log = log;
        this.treeConfig = Lazy.of(() -> this.buildTreeConfig(log, height, false));
        this.treeConfigWild = Lazy.of(() -> this.buildTreeConfig(log, height, true));
        this.configKey = new ResourceLocation("fruitsdelight", "tree/" + name + "_tree");
        this.configKeyWild = new ResourceLocation("fruitsdelight", "tree/" + name + "_tree_wild");
        this.placementKey = new ResourceLocation("fruitsdelight", "tree/" + name + "_tree");
        this.leaves = height.buildLeave(name, this);
        BlockBuilder saplingBuilder = FruitsDelight.REGISTRATE.block(name + "_sapling", p -> new SaplingBlock((AbstractTreeGrower)new TreeGrower(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cross(ctx.getName(), pvd.modLoc("block/" + ctx.getName()))).renderType("cutout"))).tag(new TagKey[]{BlockTags.f_13104_});
        this.sapling = ((BlockBuilder)height.sapling((BlockBuilder<SaplingBlock, L2Registrate>)saplingBuilder).tag(new TagKey[]{ItemTags.f_13180_}).build()).register();
        this.pot = FruitsDelight.REGISTRATE.block("potted_" + name + "_sapling", p -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, this::getSapling, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_())).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(ctx.getName(), "block/flower_pot_cross")).texture("plant", pvd.modLoc("block/" + name + "_sapling"))).renderType("cutout"))).loot((pvd, block) -> pvd.m_124165_((Block)block, RegistrateBlockLootTables.m_124270_((ItemLike)this.getSapling()))).defaultLang().register();
        this.fruit = items.apply(name);
    }

    private FDTrees(Supplier<Block> log, FDTreeType height, int food, float sat, boolean fast, int spawn) {
        this(log, height, name -> ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new Item(p.m_41489_(FDTrees.food(food, sat, fast)))).transform(b -> PlantDataEntry.addFruitTags(name, b))).register(), spawn);
        this.genTree = true;
    }

    public BaseLeavesBlock getLeaves() {
        return (BaseLeavesBlock)((Object)this.leaves.get());
    }

    @Override
    public Item getFruit() {
        return this.fruit.get();
    }

    public SaplingBlock getSapling() {
        return (SaplingBlock)this.sapling.get();
    }

    @Override
    public void registerComposter() {
        ComposterBlock.f_51914_.put((Object)this.getFruit(), 0.65f);
        ComposterBlock.f_51914_.put((Object)this.getLeaves().m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)this.getSapling().m_5456_(), 0.3f);
        ((FlowerPotBlock)this.pot.get()).getEmptyPot().addPlant(this.sapling.getId(), this.pot);
    }

    @Override
    public void registerConfigs() {
        this.treeCF = FeatureUtils.m_206488_((String)this.configKey.toString(), (Feature)Feature.f_65760_, (FeatureConfiguration)((TreeConfiguration)this.treeConfig.get()));
        this.wildCF = FeatureUtils.m_206488_((String)this.configKeyWild.toString(), (Feature)Feature.f_65760_, (FeatureConfiguration)((TreeConfiguration)this.treeConfigWild.get()));
    }

    @Override
    public void registerPlacements() {
        this.wildPF = PlacementUtils.m_206509_((String)this.placementKey.toString(), this.wildCF, (List)VegetationPlacements.m_195481_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)(1.0f / ((float)this.spawn + 3.0E-6f)), (int)1), (Block)this.getSapling()));
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Holder<PlacedFeature> getPlacementKey() {
        return this.wildPF;
    }

    private TreeConfiguration buildTreeConfig(Supplier<Block> log, FDTreeType height, boolean wild) {
        return height.build(log.get(), this.getLeaves(), wild);
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().m_38760_(food).m_38758_(sat);
        if (fast) {
            ans.m_38766_();
        }
        return ans.m_38767_();
    }

    public static void register() {
    }

    private class TreeGrower
    extends AbstractTreeGrower {
        private TreeGrower() {
        }

        protected Holder<? extends ConfiguredFeature<?, ?>> m_213888_(RandomSource rand, boolean large) {
            return FDTrees.this.treeCF;
        }
    }
}

