/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class FDModConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue fruitsGrowChance;
        public final ForgeConfigSpec.DoubleValue fruitsDropChance;
        public final ForgeConfigSpec.DoubleValue flowerDecayChance;
        public final ForgeConfigSpec.DoubleValue peachGrowChance;
        public final ForgeConfigSpec.DoubleValue peachFruitChance;
        public final ForgeConfigSpec.DoubleValue peachDecayChance;
        public final ForgeConfigSpec.IntValue rageEffectRange;
        public final ForgeConfigSpec.IntValue healEffectRange;
        public final ForgeConfigSpec.IntValue alienatingEffectRange;
        public final ForgeConfigSpec.BooleanValue enableCauldronRecipe;

        Common(ForgeConfigSpec.Builder builder) {
            this.fruitsGrowChance = builder.comment("Chance for fruits to grow per random tick").defineInRange("fruitsGrowChance", 0.1, 0.0, 1.0);
            this.fruitsDropChance = builder.comment("Chance for fruits to drop per random tick").defineInRange("fruitsDropChance", 0.1, 0.0, 1.0);
            this.flowerDecayChance = builder.comment("Chance for flower to decay when fruits are picked up / dropped").defineInRange("flowerDecayChance", 0.1, 0.0, 1.0);
            this.peachGrowChance = builder.comment("Chance for peach to grow per random tick").defineInRange("peachGrowChance", 0.1, 0.0, 1.0);
            this.peachFruitChance = builder.comment("Chance for peach to grow fruit when stop flowering").defineInRange("peachFruitChance", 0.3, 0.0, 1.0);
            this.peachDecayChance = builder.comment("Chance for peach to decay when fruiting").defineInRange("peachDecayChance", 0.1, 0.0, 1.0);
            this.rageEffectRange = builder.comment("Effect application range for Rage Aura effect").defineInRange("rageEffectRange", 24, 0, 64);
            this.healEffectRange = builder.comment("Effect application range for Heal Aura effect").defineInRange("healEffectRange", 6, 0, 64);
            this.alienatingEffectRange = builder.comment("Effect application range for Alienating effect").defineInRange("alienatingEffectRange", 12, 0, 64);
            this.enableCauldronRecipe = builder.comment("Enable cauldron jam and jello recipe").define("enableCauldronRecipe", true);
        }
    }
}

