/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init;

import com.mojang.logging.LogUtils;
import dev.xkmc.fruitsdelight.compat.create.CreateCompat;
import dev.xkmc.fruitsdelight.compat.thirst.ThirstCompat;
import dev.xkmc.fruitsdelight.events.BlockEffectToClient;
import dev.xkmc.fruitsdelight.init.data.FDBiomeTagsProvider;
import dev.xkmc.fruitsdelight.init.data.FDConfigGen;
import dev.xkmc.fruitsdelight.init.data.FDGLMProvider;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.data.RecipeGen;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.FDCauldrons;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.fruitsdelight.init.food.FDJuice;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.fruitsdelight.init.registrate.FDBlocks;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import dev.xkmc.fruitsdelight.init.registrate.FDFluids;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import dev.xkmc.fruitsdelight.init.registrate.FDMiscs;
import dev.xkmc.fruitsdelight.init.registrate.FDTab;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.base.effects.EffectSyncEvents;
import dev.xkmc.l2library.repack.registrate.providers.ProviderType;
import dev.xkmc.l2library.serial.network.PacketHandler;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import org.slf4j.Logger;

@Mod(value="fruitsdelight")
@Mod.EventBusSubscriber(modid="fruitsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FruitsDelight {
    public static final String MODID = "fruitsdelight";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("fruitsdelight");
    public static final PacketHandler HANDLER = new PacketHandler(new ResourceLocation("fruitsdelight", "main"), 1, new Function[]{e -> e.create(BlockEffectToClient.class, NetworkDirection.PLAY_TO_CLIENT)});
    public static final FDTab TAB = new FDTab();

    public FruitsDelight() {
        FDTrees.register();
        FDBushes.register();
        FDMelons.register();
        FDPineapple.register();
        FDItems.register();
        FDEffects.register();
        FDJuice.register();
        FDFood.register();
        FDBlocks.register();
        FDCauldrons.register();
        FDMiscs.register();
        FDModConfig.init();
        FDGLMProvider.register();
        FDFluids.register();
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipes);
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::genLang);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PlantDataEntry.run(PlantDataEntry::registerConfigs);
            PlantDataEntry.run(PlantDataEntry::registerPlacements);
            PlantDataEntry.run(PlantDataEntry::registerComposter);
            Durian.registerComposter();
            if (((Boolean)FDModConfig.COMMON.enableCauldronRecipe.get()).booleanValue()) {
                FDCauldrons.init();
            }
            if (ModList.get().isLoaded("create")) {
                CreateCompat.init();
            }
            EffectSyncEvents.TRACKED.add((MobEffect)FDEffects.RAGE_AURA.get());
            EffectSyncEvents.TRACKED.add((MobEffect)FDEffects.HEAL_AURA.get());
            if (ModList.get().isLoaded("thirst")) {
                ThirstCompat.init();
            }
        });
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean server = event.includeServer();
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(server, (DataProvider)new FDConfigGen(gen));
        gen.m_236039_(server, (DataProvider)new FDBiomeTagsProvider(gen, event.getExistingFileHelper()));
        gen.m_236039_(server, (DataProvider)new FDGLMProvider(gen));
    }

    static {
        REGISTRATE.creativeModeTab(() -> TAB);
    }
}

