/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.item;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.fruitsdelight.content.item.IFDFoodItem;
import dev.xkmc.fruitsdelight.init.data.LangData;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.EffectFunc;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class FDFoodItem
extends Item
implements IFDFoodItem {
    public static final String ROOT = "JellyEffectRoot";
    @Nullable
    public final IFDFood food;
    private final UseAnim anim;

    private static List<FruitType> getFruits(ItemStack stack) {
        ArrayList<FruitType> ans = new ArrayList<FruitType>();
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(ROOT)) {
            ListTag strs = stack.m_41783_().m_128437_(ROOT, 8);
            for (int i = 0; i < strs.size(); ++i) {
                String str = strs.m_128778_(i);
                try {
                    ans.add(FruitType.valueOf(str));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ans;
    }

    private static Component getTooltip(MobEffectInstance eff) {
        MutableComponent ans = Component.m_237115_((String)eff.m_19576_());
        MobEffect mobeffect = eff.m_19544_();
        if (eff.m_19564_() > 0) {
            ans = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.m_237115_((String)("potion.potency." + eff.m_19564_()))});
        }
        if (eff.m_19557_() > 20) {
            ans = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.m_19581_((MobEffectInstance)eff, (float)1.0f)});
        }
        return ans.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static void getFoodEffects(ItemStack stack, List<Component> list) {
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null) {
            return;
        }
        FDFoodItem.getFoodEffects(food, list);
    }

    public static void getFoodEffects(FoodProperties food, List<Component> list) {
        for (Pair eff : food.m_38749_()) {
            int chance = Math.round(((Float)eff.getSecond()).floatValue() * 100.0f);
            if (eff.getFirst() == null) continue;
            Component ans = FDFoodItem.getTooltip((MobEffectInstance)eff.getFirst());
            if (chance == 100) {
                list.add(ans);
                continue;
            }
            list.add((Component)LangData.CHANCE_EFFECT.get(ans, chance));
        }
    }

    public static int color(ItemStack stack, int layer) {
        List<FruitType> list = FDFoodItem.getFruits(stack);
        if (layer == 0 || list.isEmpty()) {
            return -1;
        }
        return list.get((int)(layer % list.size())).color;
    }

    public static ItemStack setContent(FDFoodItem item, FruitType e) {
        ItemStack ans = item.m_7968_();
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)e.name()));
        ans.m_41784_().m_128365_(ROOT, (Tag)list);
        return ans;
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity consumer) {
        ItemStack itemStack = this.getCraftingRemainingItem(stack);
        super.m_5922_(stack, worldIn, consumer);
        if (itemStack.m_41619_()) {
            return stack;
        }
        if (stack.m_41619_()) {
            return itemStack;
        }
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            if (!player.m_150110_().f_35937_ && !player.m_150109_().m_36054_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
        }
        return stack;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        List<FruitType> list = FDFoodItem.getFruits(stack);
        if (!list.isEmpty()) {
            FoodProperties old = super.getFoodProperties(stack, entity);
            if (old == null) {
                return null;
            }
            FoodProperties.Builder builder = new FoodProperties.Builder();
            builder.m_38760_(old.m_38744_());
            builder.m_38758_(old.m_38745_());
            if (old.m_38747_()) {
                builder.m_38765_();
            }
            if (old.m_38748_()) {
                builder.m_38766_();
            }
            if (old.m_38746_()) {
                builder.m_38757_();
            }
            if (this.food == null) {
                return null;
            }
            LinkedHashMap<FruitType, Integer> map = new LinkedHashMap<FruitType, Integer>();
            map.put(this.food.fruit(), this.food.getType().effectLevel);
            int lv = FoodType.JELLY.effectLevel;
            for (FruitType fruitType : list) {
                map.compute(fruitType, (k, v) -> v == null ? lv : v + lv);
            }
            for (Map.Entry entry : map.entrySet()) {
                for (EffectFunc effectFunc : ((FruitType)((Object)entry.getKey())).eff) {
                    builder.effect(() -> effectFunc.getEffect((Integer)entry.getValue()), effectFunc.getChance((Integer)entry.getValue()));
                }
            }
            for (Iterator<Object> iterator : this.food.getEffects()) {
                builder.effect(() -> iterator.getEffect(), ((EffectEntry)((Object)iterator)).chance());
            }
            return builder.m_38767_();
        }
        return super.getFoodProperties(stack, entity);
    }

    public FDFoodItem(Item.Properties props, @Nullable IFDFood food, UseAnim anim) {
        super(props);
        this.food = food;
        this.anim = anim;
    }

    public FDFoodItem(Item.Properties props, @Nullable IFDFood food) {
        this(props, food, UseAnim.EAT);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.anim;
    }

    public SoundEvent m_6023_() {
        if (this.food != null && this.food.getType() == FoodType.JELLY) {
            return SoundEvents.f_11970_;
        }
        return SoundEvents.f_11911_;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        List<FruitType> types = FDFoodItem.getFruits(stack);
        if (!types.isEmpty()) {
            list.add((Component)LangData.JELLY_CONTENT.get(new Object[0]));
            for (FruitType type : types) {
                list.add((Component)type.getJelly().m_41466_().m_6881_().m_130940_(ChatFormatting.GRAY));
            }
        } else if (stack.m_204117_(TagGen.ALLOW_JELLY)) {
            list.add((Component)LangData.ALLOW_JELLY.get(new Object[0]));
        }
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            FDFoodItem.getFoodEffects(stack, list);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> tab) {
        FDFood fd;
        FruitType[] fruitTypeArray;
        block5: {
            block4: {
                if (!this.m_220152_(pCategory) || !((fruitTypeArray = this.food) instanceof FDFood)) break block4;
                fd = (FDFood)fruitTypeArray;
                if (fd.overlay > 0) break block5;
            }
            super.m_6787_(pCategory, tab);
            return;
        }
        fruitTypeArray = FruitType.values();
        int n = fruitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FruitType fruit = fruitTypeArray[n2];
            ItemStack stack = new ItemStack((ItemLike)this);
            ListTag list = new ListTag();
            for (int i = 0; i < fd.overlay; ++i) {
                list.add((Object)StringTag.m_129297_((String)fruit.name()));
            }
            stack.m_41784_().m_128365_(ROOT, (Tag)list);
            tab.add((Object)stack);
            ++n2;
        }
    }

    @Override
    @Nullable
    public IFDFood food() {
        return this.food;
    }
}

