/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.util;

import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.Palette;

public class ChunkPacketInfo<T> {
    private final ClientboundLevelChunkWithLightPacket chunkPacket;
    private final LevelChunk chunk;
    private final int[] bits;
    private final Object[] palettes;
    private final int[] indexes;
    private final Object[][] presetValues;
    private byte[] buffer;

    public ChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, LevelChunk chunk) {
        this.chunkPacket = chunkPacket;
        this.chunk = chunk;
        int sections = chunk.m_151559_();
        this.bits = new int[sections];
        this.palettes = new Object[sections];
        this.indexes = new int[sections];
        this.presetValues = new Object[sections][];
    }

    public ClientboundLevelChunkWithLightPacket getChunkPacket() {
        return this.chunkPacket;
    }

    public LevelChunk getChunk() {
        return this.chunk;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int getBits(int chunkSectionIndex) {
        return this.bits[chunkSectionIndex];
    }

    public void setBits(int chunkSectionIndex, int bits) {
        this.bits[chunkSectionIndex] = bits;
    }

    public Palette<T> getPalette(int chunkSectionIndex) {
        return (Palette)this.palettes[chunkSectionIndex];
    }

    public void setPalette(int chunkSectionIndex, Palette<T> palette) {
        this.palettes[chunkSectionIndex] = palette;
    }

    public int getIndex(int chunkSectionIndex) {
        return this.indexes[chunkSectionIndex];
    }

    public void setIndex(int chunkSectionIndex, int index) {
        this.indexes[chunkSectionIndex] = index;
    }

    public T[] getPresetValues(int chunkSectionIndex) {
        return this.presetValues[chunkSectionIndex];
    }

    public void setPresetValues(int chunkSectionIndex, T[] presetValues) {
        this.presetValues[chunkSectionIndex] = presetValues;
    }

    public boolean isWritten(int chunkSectionIndex) {
        return this.bits[chunkSectionIndex] != 0;
    }
}

