/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.util;

public final class BitStorageReader {
    private byte[] buffer;
    private int bits;
    private int mask;
    private int longInBufferIndex;
    private int bitInLongIndex;
    private long current;

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public void setBits(int bits) {
        this.bits = bits;
        this.mask = (1 << bits) - 1;
    }

    public void setIndex(int index) {
        this.longInBufferIndex = index;
        this.bitInLongIndex = 0;
        this.init();
    }

    private void init() {
        if (this.buffer.length > this.longInBufferIndex + 7) {
            this.current = (long)this.buffer[this.longInBufferIndex] << 56 | ((long)this.buffer[this.longInBufferIndex + 1] & 0xFFL) << 48 | ((long)this.buffer[this.longInBufferIndex + 2] & 0xFFL) << 40 | ((long)this.buffer[this.longInBufferIndex + 3] & 0xFFL) << 32 | ((long)this.buffer[this.longInBufferIndex + 4] & 0xFFL) << 24 | ((long)this.buffer[this.longInBufferIndex + 5] & 0xFFL) << 16 | ((long)this.buffer[this.longInBufferIndex + 6] & 0xFFL) << 8 | (long)this.buffer[this.longInBufferIndex + 7] & 0xFFL;
        }
    }

    public int read() {
        if (this.bitInLongIndex + this.bits > 64) {
            this.bitInLongIndex = 0;
            this.longInBufferIndex += 8;
            this.init();
        }
        int value = (int)(this.current >>> this.bitInLongIndex) & this.mask;
        this.bitInLongIndex += this.bits;
        return value;
    }
}

