/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.mixin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.drex.antixray.interfaces.IPalettedContainer;
import me.drex.antixray.util.ChunkPacketInfo;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T>
implements IPalettedContainer<T> {
    @Unique
    private T[] presetValues;
    @Unique
    private List<T> paletteEntries;
    @Shadow
    private volatile PalettedContainer.Data<T> f_188032_;
    @Shadow
    @Final
    private PalettedContainer.Strategy f_188033_;
    @Shadow
    @Final
    private IdMap<T> f_63071_;

    @Shadow
    public abstract void m_63084_();

    @Shadow
    public abstract void m_63120_();

    @Shadow
    public abstract int m_7248_(int var1, T var2);

    @Shadow
    protected abstract PalettedContainer.Data<T> m_188051_(PalettedContainer.Data<T> var1, int var2);

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/chunk/PalettedContainer$Strategy;Lnet/minecraft/world/level/chunk/PalettedContainer$Configuration;Lnet/minecraft/util/BitStorage;Ljava/util/List;)V"}, at={@At(value="TAIL")})
    private void prepareVariables(IdMap<T> idMap, PalettedContainer.Strategy strategy, PalettedContainer.Configuration<T> configuration, BitStorage bitStorage, List<T> list, CallbackInfo ci) {
        this.paletteEntries = list;
    }

    @Redirect(method={"onResize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;createOrReuseData(Lnet/minecraft/world/level/chunk/PalettedContainer$Data;I)Lnet/minecraft/world/level/chunk/PalettedContainer$Data;"))
    private PalettedContainer.Data<T> addPresetValues(PalettedContainer<T> container, PalettedContainer.Data<T> data, int bits, int i, T object) {
        if (this.presetValues != null && object != null && data.f_188100_().f_188085_() == PalettedContainer.Strategy.f_188134_) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(object) ? 1 : 0;
            bits = Mth.m_14163_((int)((1 << this.f_188033_.m_188151_(this.f_63071_, 1 << bits)) + presetValues.size() - (duplicates += presetValues.contains(data.f_188102_().m_5795_(0)) ? 1 : 0)));
        }
        return this.m_188051_(data, bits);
    }

    @Redirect(method={"onResize"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/Palette;idFor(Ljava/lang/Object;)I"))
    private int addPresetValues(Palette<T> palette, T object) {
        this.addPresetValues();
        return object == null ? -1 : palette.m_6796_(object);
    }

    @Override
    public void addPresetValuesWithEntries(T[] presetValues) {
        this.presetValues = presetValues;
        PalettedContainer.Configuration provider = this.f_188032_.f_188100_();
        if (presetValues != null && (provider.f_188085_() == PalettedContainer.Strategy.f_188134_ ? this.f_188032_.f_188102_().m_5795_(0) != Blocks.f_50016_.m_49966_() : provider.f_188085_() != PalettedContainer.Strategy.f_188139_)) {
            int maxSize = 1 << provider.f_188086_();
            for (T presetValue : presetValues) {
                if (this.f_188032_.f_188102_().m_62680_() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(this.paletteEntries);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = Mth.m_14163_((int)allValues.size());
                    if (newBits <= provider.f_188086_()) break;
                    this.m_7248_(newBits, null);
                    break;
                }
                this.f_188032_.f_188102_().m_6796_(presetValue);
            }
        }
    }

    @Override
    public void addPresetValues(T[] presetValues) {
        this.presetValues = presetValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FriendlyByteBuf buf, ChunkPacketInfo<T> chunkPacketInfo, int bottomBlockY) {
        this.m_63084_();
        try {
            int chunkSectionIndex;
            buf.writeByte(this.f_188032_.f_188101_().m_144604_());
            this.f_188032_.f_188102_().m_5678_(buf);
            if (chunkPacketInfo != null) {
                chunkSectionIndex = (bottomBlockY >> 4) - chunkPacketInfo.getChunk().m_151560_();
                chunkPacketInfo.setBits(chunkSectionIndex, this.f_188032_.f_188100_().f_188086_());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.f_188032_.f_188102_());
                chunkPacketInfo.setIndex(chunkSectionIndex, buf.writerIndex() + FriendlyByteBuf.m_130053_((int)this.f_188032_.f_188101_().m_13513_().length));
            }
            buf.m_130091_(this.f_188032_.f_188101_().m_13513_());
            if (chunkPacketInfo != null) {
                chunkSectionIndex = (bottomBlockY >> 4) - chunkPacketInfo.getChunk().m_151560_();
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.m_63120_();
        }
    }

    private void addPresetValues() {
        if (this.presetValues != null && this.f_188032_.f_188100_().f_188085_() != PalettedContainer.Strategy.f_188139_) {
            for (T presetValue : this.presetValues) {
                this.f_188032_.f_188102_().m_6796_(presetValue);
            }
        }
    }
}

