/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.api.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Event<T> {
    private final List<Entry> listeners = new ArrayList<Entry>();

    public void register(T listener) {
        this.listeners.add(new Entry(listener, 0, () -> true));
    }

    public void register(T listener, int priority) {
        this.listeners.add(new Entry(listener, priority, () -> true));
    }

    public void register(T listener, Supplier<Boolean> enabled) {
        this.listeners.add(new Entry(listener, 0, enabled));
    }

    public void register(T listener, int priority, Supplier<Boolean> enabled) {
        this.listeners.add(new Entry(listener, priority, enabled));
    }

    public void unregister(T listener) {
        this.listeners.removeIf(entry -> entry.listener == listener);
    }

    public List<T> getListeners() {
        ImmutableList.Builder result = ImmutableList.builder();
        this.listeners.sort(null);
        for (Entry entry : this.listeners) {
            if (!entry.condition.get().booleanValue()) continue;
            result.add(entry.listener);
        }
        return result.build();
    }

    public class Entry
    implements Comparable<Entry> {
        private final T listener;
        private final int index;
        private final Supplier<Boolean> condition;

        public Entry(T listener, int index, Supplier<Boolean> condition) {
            this.listener = listener;
            this.index = index;
            this.condition = condition;
        }

        public T getListener() {
            return this.listener;
        }

        public int getIndex() {
            return this.index;
        }

        public Supplier<Boolean> getCondition() {
            return this.condition;
        }

        @Override
        public int compareTo(@NotNull Entry o) {
            return Integer.compare(this.index, o.index);
        }
    }
}

