/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.doabarrelroll.MomentumCrosshairWidget;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.net.HandshakeClient;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.config.SyncedModConfig;
import nl.enjarai.doabarrelroll.flight.ElytraMath;
import nl.enjarai.doabarrelroll.flight.RotationModifiers;
import nl.enjarai.doabarrelroll.flight.util.RotationInstant;
import nl.enjarai.doabarrelroll.util.MixinHooks;
import nl.enjarai.doabarrelroll.util.Vec2d;

public class DoABarrelRollClient {
    public static final HandshakeClient<SyncedModConfig> HANDSHAKE_CLIENT = new HandshakeClient<SyncedModConfig>(SyncedModConfig.TRANSFER_CODEC, ModConfig.INSTANCE::notifyPlayerOfServerConfig);
    public static final SmoothDouble PITCH_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble YAW_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble ROLL_SMOOTHER = new SmoothDouble();
    private static double lastLookUpdate;
    private static double lastLerpUpdate;
    public static double landingLerp;
    public static Vec3 left;
    public static Vec2d mouseTurnVec;
    public static double throttle;

    public static void init() {
        RollEvents.SHOULD_ROLL_CHECK.register(DoABarrelRollClient::isFallFlying);
        RollEvents.EARLY_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.useModifier(RotationModifiers::manageThrottle, ModConfig.INSTANCE::getEnableThrust).useModifier(RotationModifiers.strafeButtons(1800.0)), 10, DoABarrelRollClient::isFallFlying);
        RollEvents.EARLY_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.useModifier(ModConfig.INSTANCE::configureRotation), 20, DoABarrelRollClient::isFallFlying);
        RollEvents.LATE_CAMERA_MODIFIERS.register((rotationDelta, currentRotation) -> rotationDelta.smooth(PITCH_SMOOTHER, YAW_SMOOTHER, ROLL_SMOOTHER, ModConfig.INSTANCE.getSmoothing()).useModifier(RotationModifiers::banking, ModConfig.INSTANCE::getEnableBanking), 10, DoABarrelRollClient::isFallFlying);
    }

    public static boolean updateMouse(LocalPlayer player, double cursorDeltaX, double cursorDeltaY) {
        if (!DoABarrelRollClient.isRolling()) {
            return true;
        }
        landingLerp = 0.0;
        if (ModConfig.INSTANCE.getMomentumBasedMouse()) {
            Vec2d turnVec = mouseTurnVec.add(new Vec2d(cursorDeltaX, cursorDeltaY).multiply(0.0033333334140479565));
            if (turnVec.lengthSquared() > 1.0) {
                turnVec = turnVec.normalize();
            }
            mouseTurnVec = turnVec;
            double delta = DoABarrelRollClient.getDelta();
            Vec2d readyTurnVec = mouseTurnVec.multiply(1200.0f * (float)delta);
            DoABarrelRollClient.changeElytraLook(readyTurnVec.y, readyTurnVec.x, 0.0, ModConfig.INSTANCE.getDesktopSensitivity(), delta);
        } else {
            mouseTurnVec = Vec2d.ZERO;
            DoABarrelRollClient.changeElytraLook(cursorDeltaY, cursorDeltaX, 0.0, ModConfig.INSTANCE.getDesktopSensitivity());
        }
        return false;
    }

    public static void onWorldRender(Minecraft client, float tickDelta, PoseStack matrix) {
        double time = Blaze3D.m_83640_();
        double lerpDelta = time - lastLerpUpdate;
        lastLerpUpdate = time;
        if (!DoABarrelRollClient.isRolling()) {
            landingLerp = Mth.m_14139_((double)Mth.m_14008_((double)(lerpDelta * 2.0), (double)0.0, (double)1.0), (double)landingLerp, (double)1.0);
            if (landingLerp > 0.9) {
                landingLerp = 1.0;
            }
            DoABarrelRollClient.clearValues();
            if (client.f_91074_ != null) {
                left = left.m_165921_(ElytraMath.getAssumedLeft(client.f_91074_.m_146908_()), landingLerp);
            }
        } else if (client.m_91104_()) {
            lastLookUpdate = Blaze3D.m_83640_();
        } else {
            DoABarrelRollClient.changeElytraLook(0.0, 0.0, 0.0, ModConfig.INSTANCE.getDesktopSensitivity());
        }
        if (client.f_91074_ != null && landingLerp < 1.0) {
            double angle = -Math.acos(Mth.m_14008_((double)left.m_82526_(ElytraMath.getAssumedLeft(client.f_91074_.m_146908_())), (double)-1.0, (double)1.0)) * 57.29577951308232;
            if (left.m_7098_() < 0.0) {
                angle *= -1.0;
            }
            if (client.f_91066_.m_92176_().m_90613_()) {
                angle *= -1.0;
            }
            matrix.m_85845_(Vector3f.f_122227_.m_122240_((float)angle));
        }
    }

    public static void onRenderCrosshair(PoseStack matrices, int scaledWidth, int scaledHeight) {
        if (!(DoABarrelRollClient.isFallFlying() && ModConfig.INSTANCE.getMomentumBasedMouse() && ModConfig.INSTANCE.getShowMomentumWidget())) {
            return;
        }
        MomentumCrosshairWidget.render(matrices, scaledWidth, scaledHeight, mouseTurnVec);
    }

    private static void clearValues() {
        PITCH_SMOOTHER.m_14236_();
        YAW_SMOOTHER.m_14236_();
        ROLL_SMOOTHER.m_14236_();
        mouseTurnVec = Vec2d.ZERO;
        lastLookUpdate = Blaze3D.m_83640_();
        throttle = 0.0;
    }

    private static double getDelta() {
        double time = Blaze3D.m_83640_();
        double delta = time - lastLookUpdate;
        lastLookUpdate = time;
        return delta;
    }

    public static void changeElytraLook(double pitch, double yaw, double roll, Sensitivity sensitivity) {
        DoABarrelRollClient.changeElytraLook(pitch, yaw, roll, sensitivity, DoABarrelRollClient.getDelta());
    }

    public static void changeElytraLook(double pitch, double yaw, double roll, Sensitivity sensitivity, double delta) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RotationInstant rotDelta = new RotationInstant(pitch, yaw, roll, delta);
        double currentRoll = ElytraMath.getRoll(player.m_146908_(), left);
        RotationInstant currentRotation = new RotationInstant(player.m_146909_(), player.m_146908_(), currentRoll, 0.0);
        ElytraMath.changeElytraLookDirectly(player, RollEvents.lateCameraModifiers(RollEvents.earlyCameraModifiers(rotDelta, currentRotation).applySensitivity(sensitivity), currentRotation));
    }

    public static boolean isFallFlying() {
        LocalPlayer player;
        if (!HANDSHAKE_CLIENT.getConfig().map(SyncedModConfig::forceEnabled).orElse(false).booleanValue()) {
            boolean hybrid;
            boolean bl = hybrid = ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID || ModConfig.INSTANCE.getActivationBehaviour() == ActivationBehaviour.HYBRID_TOGGLE;
            if (hybrid && !MixinHooks.thirdJump) {
                return false;
            }
            if (!ModConfig.INSTANCE.getModEnabled()) {
                return false;
            }
        }
        return (player = Minecraft.m_91087_().f_91074_) != null && player.m_21255_();
    }

    public static boolean isRolling() {
        return RollEvents.shouldRoll();
    }

    static {
        landingLerp = 1.0;
        mouseTurnVec = Vec2d.ZERO;
        throttle = 0.0;
    }
}

