/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule.impl;

import com.mojang.serialization.DynamicOps;
import java.util.function.IntPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.Logger;
import snownee.kiwi.Kiwi;
import snownee.kiwi.schedule.Task;
import snownee.kiwi.schedule.impl.LevelTicker;

public class SimpleLevelTask
extends Task<LevelTicker>
implements INBTSerializable<CompoundTag> {
    protected int tick = 0;
    protected ResourceKey<Level> dimension;
    protected TickEvent.Phase phase;
    protected IntPredicate function;

    public SimpleLevelTask() {
    }

    public SimpleLevelTask(Level world, TickEvent.Phase phase, IntPredicate function) {
        this((ResourceKey<Level>)world.m_46472_(), phase, function);
    }

    public SimpleLevelTask(ResourceKey<Level> dimensionType, TickEvent.Phase phase, IntPredicate function) {
        this.dimension = dimensionType;
        this.phase = phase;
        this.function = function;
    }

    @Override
    public boolean tick(LevelTicker ticker) {
        return this.function.test(++this.tick);
    }

    @Override
    public LevelTicker ticker() {
        return LevelTicker.get(this.dimension, this.phase);
    }

    @Override
    public boolean shouldSave() {
        return this.getClass() != SimpleLevelTask.class;
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("tick", this.tick);
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, this.dimension).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).ifPresent(nbt -> data.m_128365_("world", nbt));
        data.m_128379_("start", this.phase == TickEvent.Phase.START);
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.dimension = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("world")).resultOrPartial(arg_0 -> ((Logger)Kiwi.logger).error(arg_0)).orElse(Level.f_46428_);
        this.tick = nbt.m_128451_("tick");
        this.phase = nbt.m_128471_("start") ? TickEvent.Phase.START : TickEvent.Phase.END;
    }
}

