/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.entity;

import net.lordkipama.modernminecarts.entity.CustomAbstractMinecartEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class CustomMinecartTNTEntity
extends CustomAbstractMinecartEntity {
    private static final byte EVENT_PRIME = 10;
    private int fuse = -1;

    public CustomMinecartTNTEntity(EntityType<? extends CustomMinecartTNTEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public CustomMinecartTNTEntity(Level pLevel, double pX, double pY, double pZ) {
        super(EntityType.f_20475_, pLevel, pX, pY, pZ);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.TNT;
    }

    public BlockState m_6390_() {
        return Blocks.f_50077_.m_49966_();
    }

    @Override
    public void m_8119_() {
        double d0;
        super.m_8119_();
        if (this.fuse > 0) {
            --this.fuse;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.m_20184_().m_165925_());
        }
        if (this.f_19862_ && (d0 = this.m_20184_().m_165925_()) >= (double)0.01f) {
            this.explode(d0);
        }
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        AbstractArrow abstractarrow;
        Entity entity = pSource.m_7640_();
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_6060_()) {
            this.explode(abstractarrow.m_20184_().m_82556_());
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7617_(DamageSource pSource) {
        double d0 = this.m_20184_().m_165925_();
        if (!(pSource.m_19384_() || pSource.m_19372_() || d0 >= (double)0.01f)) {
            super.m_7617_(pSource);
        } else if (this.fuse < 0) {
            this.primeFuse();
            this.fuse = this.f_19796_.m_188503_(20) + this.f_19796_.m_188503_(20);
        }
    }

    protected Item m_213728_() {
        if (this.getLinkedParent() != null || this.getLinkedChild() != null) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42026_)));
        }
        return Items.f_42693_;
    }

    protected void explode(double pRadiusModifier) {
        if (!this.f_19853_.f_46443_) {
            double d0 = Math.sqrt(pRadiusModifier);
            if (d0 > 5.0) {
                d0 = 5.0;
            }
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)(4.0 + this.f_19796_.m_188500_() * 1.5 * d0), Explosion.BlockInteraction.BREAK);
            this.m_146870_();
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (pFallDistance >= 3.0f) {
            float f = pFallDistance / 10.0f;
            this.explode(f * f);
        }
        return super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    public void m_6025_(int pX, int pY, int pZ, boolean pReceivingPower) {
        if (pReceivingPower && this.fuse < 0) {
            this.primeFuse();
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 10) {
            this.primeFuse();
        } else {
            super.m_7822_(pId);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)10);
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    public float m_7077_(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, float pExplosionPower) {
        return !this.isPrimed() || !pBlockState.m_204336_(BlockTags.f_13034_) && !pLevel.m_8055_(pPos.m_7494_()).m_204336_(BlockTags.f_13034_) ? super.m_7077_(pExplosion, pLevel, pPos, pBlockState, pFluidState, pExplosionPower) : 0.0f;
    }

    public boolean m_7349_(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, float pExplosionPower) {
        return !this.isPrimed() || !pBlockState.m_204336_(BlockTags.f_13034_) && !pLevel.m_8055_(pPos.m_7494_()).m_204336_(BlockTags.f_13034_) ? super.m_7349_(pExplosion, pLevel, pPos, pBlockState, pExplosionPower) : false;
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("TNTFuse", 99)) {
            this.fuse = pCompound.m_128451_("TNTFuse");
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("TNTFuse", this.fuse);
    }
}

