/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.lordkipama.modernminecarts.ModernMinecartsConfig;
import net.lordkipama.modernminecarts.Proxy.ModernMinecartsPacketHandler;
import net.lordkipama.modernminecarts.block.Custom.PoweredDetectorRailBlock;
import net.lordkipama.modernminecarts.block.ModBlocks;
import net.lordkipama.modernminecarts.entity.ChainMinecartInterface;
import net.lordkipama.modernminecarts.entity.CustomMinecartFurnaceEntity;
import net.lordkipama.modernminecarts.entity.CustomMinecartHopperEntity;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public abstract class CustomAbstractMinecartEntity
extends AbstractMinecart
implements ChainMinecartInterface {
    private boolean jumpedOffSlope = false;
    private double maxSpeed = 0.8;
    @Nullable
    private UUID parentUUID;
    @Nullable
    private UUID childUUID;
    private int parentIdClient;
    private int childIdClient;
    private boolean flipped;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i vec3i = Direction.WEST.m_122436_();
        Vec3i vec3i1 = Direction.EAST.m_122436_();
        Vec3i vec3i2 = Direction.NORTH.m_122436_();
        Vec3i vec3i3 = Direction.SOUTH.m_122436_();
        Vec3i vec3i4 = vec3i.m_7495_();
        Vec3i vec3i5 = vec3i1.m_7495_();
        Vec3i vec3i6 = vec3i2.m_7495_();
        Vec3i vec3i7 = vec3i3.m_7495_();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });

    protected CustomAbstractMinecartEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected CustomAbstractMinecartEntity(EntityType<?> pEntityType, Level pLevel, double pX, double pY, double pZ) {
        super(pEntityType, pLevel, pX, pY, pZ);
    }

    public void m_38163_() {
        Vec3 newVec3;
        BlockState hindBlockState;
        double d0 = this.f_19861_ ? this.m_7097_() : (double)this.getMaxSpeedAirLateral();
        Vec3 vec3 = this.m_20184_();
        int x = Mth.m_14107_((double)this.m_20185_());
        int y = Mth.m_14107_((double)this.m_20186_());
        int z = Mth.m_14107_((double)this.m_20189_());
        if (vec3.f_82479_ > 0.0) {
            blockpos = new BlockPos(x - 1, y - 1, z);
            double lateralMomentum = Math.abs(vec3.f_82479_);
            hindBlockState = this.f_19853_.m_8055_(blockpos);
            newVec3 = new Vec3(Math.min(vec3.f_82479_ + 0.1, this.maxSpeed), Math.min(lateralMomentum, this.maxSpeed), 0.0);
        } else if (vec3.f_82479_ < 0.0) {
            blockpos = new BlockPos(x + 1, y - 1, z);
            double lateralMomentum = Math.abs(vec3.f_82479_);
            hindBlockState = this.f_19853_.m_8055_(blockpos);
            newVec3 = new Vec3(Math.max(vec3.f_82479_ - 0.1, -this.maxSpeed), Math.min(lateralMomentum, this.maxSpeed), 0.0);
        } else if (vec3.f_82481_ > 0.0) {
            blockpos = new BlockPos(x, y - 1, z - 1);
            double lateralMomentum = Math.abs(vec3.f_82481_);
            hindBlockState = this.f_19853_.m_8055_(blockpos);
            newVec3 = new Vec3(0.0, Math.min(lateralMomentum, this.maxSpeed), Math.min(vec3.f_82481_ + 0.1, this.maxSpeed));
        } else {
            blockpos = new BlockPos(x, y - 1, z + 1);
            double lateralMomentum = Math.abs(vec3.f_82481_);
            hindBlockState = this.f_19853_.m_8055_(blockpos);
            newVec3 = new Vec3(0.0, Math.min(lateralMomentum, this.maxSpeed), Math.max(vec3.f_82481_ - 0.1, -this.maxSpeed));
        }
        BlockPos belowBlock = new BlockPos(x, y - 1, z);
        if (!this.jumpedOffSlope && hindBlockState.m_60713_((Block)ModBlocks.SLOPED_RAIL.get()) && this.f_19853_.m_8055_(belowBlock).m_60713_(Blocks.f_50016_)) {
            vec3 = newVec3;
            this.jumpedOffSlope = true;
        } else if (!hindBlockState.m_60713_((Block)ModBlocks.SLOPED_RAIL.get())) {
            this.jumpedOffSlope = false;
        }
        this.m_20334_(Mth.m_14008_((double)vec3.f_82479_, (double)(-d0), (double)d0), vec3.f_82480_, Mth.m_14008_((double)vec3.f_82481_, (double)(-d0), (double)d0));
        if (this.f_19861_ && vec3.f_82480_ <= 0.0) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        }
        if (this.getMaxSpeedAirVertical() > 0.0f && this.m_20184_().f_82480_ > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.m_20184_().f_82479_) < (double)0.3f && Math.abs(this.m_20184_().f_82481_) < (double)0.3f) {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)0.15f, this.m_20184_().f_82481_));
            } else {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, (double)this.getMaxSpeedAirVertical(), this.m_20184_().f_82481_));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82490_(this.getDragAir()));
        }
    }

    public double getDragAir() {
        return 0.975f;
    }

    public float getMaxSpeedAirLateral() {
        return 0.8f;
    }

    protected double m_7097_() {
        return this.maxSpeed;
    }

    public void moveMinecartOnRail(BlockPos pos) {
        double distance;
        CustomAbstractMinecartEntity mc = this;
        double d24 = 1.0;
        double d25 = mc.getMaxSpeedWithRail();
        Vec3 vec3d1 = mc.m_20184_();
        this.maxSpeed = d25;
        if (this.getLinkedParent() != null && (distance = (double)(this.getLinkedParent().m_20270_((Entity)this) - 1.0f)) > 1.5) {
            d25 *= 1.2;
        }
        vec3d1 = new Vec3(Math.min(Math.max(vec3d1.m_7096_(), -d25), d25), 0.0, Math.min(Math.max(vec3d1.m_7094_(), -d25), d25));
        this.m_20256_(vec3d1);
        mc.m_6478_(MoverType.SELF, new Vec3(Mth.m_14008_((double)(d24 * vec3d1.f_82479_), (double)(-d25), (double)d25), 0.0, Mth.m_14008_((double)(d24 * vec3d1.f_82481_), (double)(-d25), (double)d25)));
    }

    public double getMaxSpeedWithRail() {
        if (!this.canUseRail()) {
            return this.m_7097_();
        }
        BlockPos pos = this.getCurrentRailPosition();
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!state.m_204336_(BlockTags.f_13034_)) {
            return this.m_7097_();
        }
        float railMaxSpeed = ((BaseRailBlock)state.m_60734_()).getRailMaxSpeed(state, this.f_19853_, pos, (AbstractMinecart)this);
        if (this.getLinkedParent() != null) {
            railMaxSpeed = 0.8f;
        }
        if (this.m_20069_() && !state.m_60713_(Blocks.f_50030_)) {
            railMaxSpeed /= 2.0f;
        }
        if (railMaxSpeed > ModernMinecartsConfig.max_ascending_speed) {
            BlockState frontBlockState;
            BlockPos blockpos;
            Vec3 vec3 = this.m_20184_();
            if (vec3.f_82479_ > 0.0) {
                blockpos = new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
                frontBlockState = this.f_19853_.m_8055_(blockpos);
            } else if (vec3.f_82479_ < 0.0) {
                blockpos = new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
                frontBlockState = this.f_19853_.m_8055_(blockpos);
            } else if (vec3.f_82481_ > 0.0) {
                blockpos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
                frontBlockState = this.f_19853_.m_8055_(blockpos);
            } else {
                blockpos = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
                frontBlockState = this.f_19853_.m_8055_(blockpos);
            }
            if (frontBlockState.m_204336_(BlockTags.f_13034_)) {
                try {
                    EnumProperty SHAPE = BlockStateProperties.f_61403_;
                    if (((RailShape)frontBlockState.m_61143_((Property)SHAPE)).m_61745_()) {
                        railMaxSpeed = ((BaseRailBlock)frontBlockState.m_60734_()).getRailMaxSpeed(frontBlockState, this.f_19853_, blockpos, (AbstractMinecart)this);
                    }
                }
                catch (Exception e) {
                    try {
                        EnumProperty SHAPE = BlockStateProperties.f_61404_;
                        if (((RailShape)frontBlockState.m_61143_((Property)SHAPE)).m_61745_()) {
                            railMaxSpeed = ((BaseRailBlock)frontBlockState.m_60734_()).getRailMaxSpeed(frontBlockState, this.f_19853_, blockpos, (AbstractMinecart)this);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_()) {
            if (this.getLinkedParent() != null) {
                double distance = this.getLinkedParent().m_20270_((Entity)this) - 1.0f;
                if (distance <= 4.0) {
                    ModernMinecartsPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ModernMinecartsPacketHandler.CouplePacket(this.getLinkedParent().m_19879_(), this.m_19879_()));
                    Vec3 direction = this.getLinkedParent().m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    Vec3 parentVelocity = this.getLinkedParent().m_20184_();
                    if (parentVelocity.m_82553_() < 0.06) {
                        this.m_20256_(direction);
                        if (distance > 1.1) {
                            this.m_20256_(this.m_20184_().m_82542_(0.06 * distance, distance, 0.06 * distance));
                        } else if (distance > 1.02) {
                            this.m_20256_(this.m_20184_().m_82542_(0.04, distance, 0.04));
                        } else if (distance < 0.9) {
                            this.m_20256_(this.m_20184_().m_82542_(-0.3, distance, -0.15));
                        } else if (distance < 0.98) {
                            this.m_20256_(this.m_20184_().m_82542_(-0.04, distance, -0.04));
                        } else {
                            this.m_20256_(this.m_20184_().m_82542_(0.0, distance, 0.0));
                        }
                    } else {
                        double newDistance = distance - 0.33;
                        this.m_20256_(direction.m_82542_(parentVelocity.m_82553_(), parentVelocity.m_82553_(), parentVelocity.m_82553_()));
                        this.m_20256_(this.m_20184_().m_82542_(Math.pow(newDistance, 2.0), newDistance, Math.pow(newDistance, 2.0)));
                    }
                } else {
                    ChainMinecartInterface.unsetParentChild(this.getLinkedParent(), this);
                    this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42026_)));
                    return;
                }
                if (this.getLinkedParent() != null) {
                    if (this.getLinkedParent().m_213877_()) {
                        ChainMinecartInterface.unsetParentChild(this.getLinkedParent(), this);
                        this.refreshTrain(false);
                    }
                } else if (this.parentUUID != null) {
                    this.refreshTrain(false);
                    this.parentUUID = null;
                }
            }
            if (this.getLinkedChild() != null) {
                if (this.getLinkedChild().m_213877_()) {
                    ChainMinecartInterface.unsetParentChild(this, this.getLinkedChild());
                    this.refreshTrain(true);
                }
            } else if (this.childUUID != null) {
                this.refreshTrain(true);
                this.childUUID = null;
            }
        }
        if (this.m_20184_().m_82553_() < 0.005) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.m_38176_() > 0) {
            this.m_38154_(this.m_38176_() - 1);
        }
        if (this.m_38169_() > 0.0f) {
            this.m_38109_(this.m_38169_() - 1.0f);
        }
        this.m_146871_();
        this.m_20157_();
        if (this.f_19853_.f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                double d2 = Mth.m_14175_((double)(this.lyr - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)d2 / (float)this.lSteps);
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
        } else {
            double d4;
            int j;
            int i;
            int k;
            if (!this.m_20068_()) {
                double d0 = this.m_20069_() ? -0.005 : -0.04;
                this.m_20256_(this.m_20184_().m_82520_(0.0, d0, 0.0));
            }
            if (this.f_19853_.m_8055_(new BlockPos(k = Mth.m_14107_((double)this.m_20185_()), (i = Mth.m_14107_((double)this.m_20186_())) - 1, j = Mth.m_14107_((double)this.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
                --i;
            }
            BlockPos blockpos = new BlockPos(k, i, j);
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            boolean onRails = BaseRailBlock.m_49416_((BlockState)blockstate);
            if (this.canUseRail() && onRails) {
                this.m_6401_(blockpos, blockstate);
                if (blockstate.m_60734_() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.m_60734_()).isActivatorRail()) {
                    this.m_6025_(k, i, j, (Boolean)blockstate.m_61143_((Property)PoweredRailBlock.f_55215_));
                }
            } else {
                this.m_38163_();
            }
            this.m_20101_();
            this.m_146926_(0.0f);
            double d1 = this.f_19854_ - this.m_20185_();
            double d3 = this.f_19856_ - this.m_20189_();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.m_146922_(this.m_146908_() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.m_14177_((float)(this.m_146908_() - this.f_19859_))) < -170.0 || d4 >= 170.0) {
                this.m_146922_(this.m_146908_() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.m_19915_(this.m_146908_(), this.m_146909_());
            AABB box = this.getCollisionHandler() != null ? this.getCollisionHandler().getMinecartCollisionBox((AbstractMinecart)this) : this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f);
            if (this.canBeRidden() && this.m_20184_().m_165925_() > 0.01) {
                List list = this.f_19853_.m_6249_((Entity)this, box, EntitySelector.m_20421_((Entity)this));
                if (!list.isEmpty()) {
                    for (Entity entity1 : list) {
                        if (!(entity1 instanceof Player || entity1 instanceof IronGolem || entity1 instanceof AbstractMinecart || this.m_20160_() || entity1.m_20159_())) {
                            entity1.m_20329_((Entity)this);
                            continue;
                        }
                        entity1.m_7334_((Entity)this);
                    }
                }
            } else {
                for (Entity entity : this.f_19853_.m_45933_((Entity)this, box)) {
                    if (this.m_20363_(entity) || !entity.m_6094_() || !(entity instanceof AbstractMinecart)) continue;
                    entity.m_7334_((Entity)this);
                }
            }
            this.m_20073_();
            if (this.m_20077_()) {
                this.m_20093_();
                this.f_19789_ *= 0.5f;
            }
            this.f_19803_ = false;
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128441_("ParentUuid")) {
            this.parentUUID = pCompound.m_128342_("ParentUuid");
        }
        if (pCompound.m_128441_("ChildUuid")) {
            this.childUUID = pCompound.m_128342_("ChildUuid");
        }
        super.m_7378_(pCompound);
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (this.parentUUID != null) {
            pCompound.m_128362_("ParentUuid", this.parentUUID);
        }
        if (this.childUUID != null) {
            pCompound.m_128362_("ChildUuid", this.childUUID);
        }
        super.m_7380_(pCompound);
    }

    @Override
    public CustomAbstractMinecartEntity getLinkedParent() {
        Entity entity = null;
        if (this.f_19853_.m_5776_()) {
            entity = this.f_19853_.m_6815_(this.parentIdClient);
        } else {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                entity = server.m_8791_(this.parentUUID);
            }
        }
        if (entity instanceof CustomAbstractMinecartEntity) {
            CustomAbstractMinecartEntity mc = (CustomAbstractMinecartEntity)entity;
            return mc;
        }
        return null;
    }

    public int getParentIdClient() {
        return this.parentIdClient;
    }

    @Override
    public void setLinkedParent(@Nullable CustomAbstractMinecartEntity parent) {
        if (parent != null) {
            this.parentUUID = parent.m_20148_();
            this.parentIdClient = parent.m_19879_();
        } else {
            this.parentUUID = null;
            this.parentIdClient = -1;
        }
        if (!this.f_19853_.m_5776_()) {
            ModernMinecartsPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ModernMinecartsPacketHandler.CouplePacket(this.getParentIdClient(), this.m_19879_()));
        }
        this.startRefreshTrain();
    }

    @Override
    public void setLinkedParentClient(int id) {
        this.parentIdClient = id;
    }

    @Override
    public CustomAbstractMinecartEntity getLinkedChild() {
        Entity entity = null;
        if (this.f_19853_.m_5776_()) {
            entity = this.f_19853_.m_6815_(this.childIdClient);
        } else {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                entity = server.m_8791_(this.childUUID);
            }
        }
        if (entity instanceof CustomAbstractMinecartEntity) {
            CustomAbstractMinecartEntity mc = (CustomAbstractMinecartEntity)entity;
            return mc;
        }
        return null;
    }

    @Override
    public void setLinkedChild(@Nullable CustomAbstractMinecartEntity child) {
        if (child != null) {
            this.childUUID = child.m_20148_();
            this.childIdClient = child.m_19879_();
        } else {
            this.childUUID = null;
            this.childIdClient = -1;
        }
        this.startRefreshTrain();
    }

    @Override
    public void setLinkedChildClient(int id) {
        this.childIdClient = id;
    }

    protected void m_6401_(BlockPos pPos, BlockState pState) {
        double d14;
        this.m_183634_();
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        Vec3 vec3 = this.m_38179_(d0, d1, d2);
        d1 = pPos.m_123342_();
        boolean flag = false;
        boolean flag1 = false;
        BaseRailBlock baserailblock = (BaseRailBlock)pState.m_60734_();
        if (baserailblock instanceof PoweredRailBlock && !((PoweredRailBlock)baserailblock).isActivatorRail()) {
            flag = (Boolean)pState.m_61143_((Property)PoweredRailBlock.f_55215_);
            flag1 = !flag;
        } else if (baserailblock instanceof PoweredDetectorRailBlock) {
            PoweredDetectorRailBlock weightedState = (PoweredDetectorRailBlock)baserailblock;
            flag = (Boolean)pState.m_61143_((Property)PoweredRailBlock.f_55215_);
            flag1 = !flag;
            Vec3 deltaMovementSpeed = this.m_20184_();
            if (this.getLinkedParent() == null) {
                if (weightedState.getDirInverted(pState)) {
                    if (weightedState.getRailShape(pState).equals((Object)RailShape.NORTH_SOUTH) || weightedState.getRailShape(pState).equals((Object)RailShape.ASCENDING_NORTH) || weightedState.getRailShape(pState).equals((Object)RailShape.ASCENDING_SOUTH)) {
                        if (deltaMovementSpeed.f_82481_ < -0.2) {
                            this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() / 8.0 + 0.1));
                        } else if (flag) {
                            this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() + 0.02));
                        } else {
                            this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() / 7.0));
                        }
                    } else if (deltaMovementSpeed.f_82479_ > 0.2) {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() / 8.0 - 0.1, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                    } else if (flag) {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() - 0.02, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                    } else {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() / 7.0, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                    }
                } else if (weightedState.getRailShape(pState).equals((Object)RailShape.NORTH_SOUTH) || weightedState.getRailShape(pState).equals((Object)RailShape.ASCENDING_NORTH) || weightedState.getRailShape(pState).equals((Object)RailShape.ASCENDING_SOUTH)) {
                    if (deltaMovementSpeed.f_82481_ > 0.2) {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() / 8.0 - 0.1));
                    } else if (flag) {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() - 0.02));
                    } else {
                        this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_(), deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_() / 7.0));
                    }
                } else if (deltaMovementSpeed.f_82479_ < -0.2) {
                    this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() / 8.0 + 0.1, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                } else if (flag) {
                    this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() + 0.02, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                } else {
                    this.m_20256_(new Vec3(deltaMovementSpeed.m_7096_() / 7.0, deltaMovementSpeed.m_7098_(), deltaMovementSpeed.m_7094_()));
                }
            }
        }
        double d3 = this.getSlopeAdjustment();
        if (this.m_20069_()) {
            d3 *= 0.2;
        }
        Vec3 vec31 = this.m_20184_();
        RailShape railshape = ((BaseRailBlock)pState.m_60734_()).getRailDirection(pState, (BlockGetter)this.f_19853_, pPos, (AbstractMinecart)this);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.m_20256_(vec31.m_82520_(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.m_20256_(vec31.m_82520_(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.m_20256_(vec31.m_82520_(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec31 = this.m_20184_();
        Pair<Vec3i, Vec3i> pair = CustomAbstractMinecartEntity.m_38125_(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.m_123341_() - vec3i.m_123341_();
        double d5 = vec3i1.m_123343_() - vec3i.m_123343_();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec31.f_82479_ * d4 + vec31.f_82481_ * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec31.m_165924_());
        vec31 = new Vec3(d8 * d4 / d6, vec31.f_82480_, d8 * d5 / d6);
        this.m_20256_(vec31);
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Vec3 vec32 = entity.m_20184_();
            double d9 = vec32.m_165925_();
            double d11 = this.m_20184_().m_82553_();
            if (d9 > 1.0E-4 && d11 < 0.2) {
                this.m_20256_(this.m_20184_().m_82520_(vec32.f_82479_ * 0.3, 0.0, vec32.f_82481_ * 0.3));
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            double d22 = this.m_20184_().m_165924_();
            if (d22 < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)pPos.m_123341_() + 0.5 + (double)vec3i.m_123341_() * 0.5;
        double d10 = (double)pPos.m_123343_() + 0.5 + (double)vec3i.m_123343_() * 0.5;
        double d12 = (double)pPos.m_123341_() + 0.5 + (double)vec3i1.m_123341_() * 0.5;
        double d13 = (double)pPos.m_123343_() + 0.5 + (double)vec3i1.m_123343_() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)pPos.m_123343_();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)pPos.m_123341_();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.m_6034_(d0, d1, d2);
        this.moveMinecartOnRail(pPos);
        if (vec3i.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - pPos.m_123341_() == vec3i.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - pPos.m_123343_() == vec3i.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i.m_123342_(), this.m_20189_());
        } else if (vec3i1.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - pPos.m_123341_() == vec3i1.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - pPos.m_123343_() == vec3i1.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vec3i1.m_123342_(), this.m_20189_());
        }
        this.m_7114_();
        Vec3 vec33 = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (vec33 != null && vec3 != null) {
            double d17 = (vec3.f_82480_ - vec33.f_82480_) * 0.05;
            Vec3 vec34 = this.m_20184_();
            double d18 = vec34.m_165924_();
            if (d18 > 0.0) {
                this.m_20256_(vec34.m_82542_((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            this.m_6034_(this.m_20185_(), vec33.f_82480_, this.m_20189_());
        }
        int j = Mth.m_14107_((double)this.m_20185_());
        int i = Mth.m_14107_((double)this.m_20189_());
        if (j != pPos.m_123341_() || i != pPos.m_123343_()) {
            Vec3 vec35 = this.m_20184_();
            double d26 = vec35.m_165924_();
            this.m_20334_(d26 * (double)(j - pPos.m_123341_()), vec35.f_82480_, d26 * (double)(i - pPos.m_123343_()));
        }
        if (this.shouldDoRailFunctions()) {
            baserailblock.onMinecartPass(pState, this.f_19853_, pPos, (AbstractMinecart)this);
        }
        if (flag && this.shouldDoRailFunctions()) {
            Vec3 vec36 = this.m_20184_();
            double d27 = vec36.m_165924_();
            if (d27 > 0.01) {
                this.m_20256_(vec36.m_82520_(vec36.f_82479_ / d27 * 0.06, 0.0, vec36.f_82481_ / d27 * 0.06));
            } else {
                Vec3 vec37 = this.m_20184_();
                double d20 = vec37.f_82479_;
                double d21 = vec37.f_82481_;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.m_38129_(pPos.m_122024_())) {
                        d20 = 0.02;
                    } else if (this.m_38129_(pPos.m_122029_())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.m_38129_(pPos.m_122012_())) {
                        d21 = 0.02;
                    } else if (this.m_38129_(pPos.m_122019_())) {
                        d21 = -0.02;
                    }
                }
                this.m_20334_(d20, vec37.f_82480_, d21);
            }
        }
    }

    private boolean m_38129_(BlockPos pPos) {
        return this.f_19853_.m_8055_(pPos).m_60796_((BlockGetter)this.f_19853_, pPos);
    }

    private static Pair<Vec3i, Vec3i> m_38125_(RailShape pShape) {
        return EXITS.get(pShape);
    }

    protected void m_7114_() {
        double d0 = 0.997;
        Vec3 vec3 = this.m_20184_();
        vec3 = vec3.m_82542_(d0, 0.0, d0);
        if (this.m_20069_()) {
            vec3 = vec3.m_82490_((double)0.95f);
        }
        this.m_20256_(vec3);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.lx = pX;
        this.ly = pY;
        this.lz = pZ;
        this.lyr = pYaw;
        this.lxr = pPitch;
        this.lSteps = pPosRotationIncrements + 2;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
        super.m_6453_(pX, pY, pZ, pYaw, pPitch, pPosRotationIncrements, pTeleport);
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.lxd = pX;
        this.lyd = pY;
        this.lzd = pZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
        super.m_6001_(pX, pY, pZ);
    }

    public List<ContainerEntity> getContainerMinecartItemstacks(List<ContainerEntity> entries, boolean directionUp, boolean checkHoppers) {
        CustomAbstractMinecartEntity parent = this.getLinkedParent();
        CustomAbstractMinecartEntity child = this.getLinkedChild();
        if (directionUp && parent != null) {
            entries.addAll(parent.getContainerMinecartItemstacks(entries, true, checkHoppers));
        } else if (!directionUp && child != null) {
            entries.addAll(child.getContainerMinecartItemstacks(entries, false, checkHoppers));
        }
        if (this instanceof CustomMinecartHopperEntity && !checkHoppers || this instanceof CustomMinecartFurnaceEntity) {
            return entries;
        }
        CustomAbstractMinecartEntity customAbstractMinecartEntity = this;
        if (customAbstractMinecartEntity instanceof ContainerEntity) {
            ContainerEntity imacontainer = (ContainerEntity)customAbstractMinecartEntity;
            entries.add(imacontainer);
            entries.add(imacontainer);
        }
        return entries;
    }

    public void startRefreshTrain() {
        this.refreshTrain(true);
        this.refreshTrain(false);
    }

    public void refreshTrain(boolean directionUp) {
        if (!directionUp && this.getLinkedChild() != null) {
            this.getLinkedChild().refreshTrain(false);
        } else if (this.getLinkedParent() != null) {
            this.getLinkedParent().refreshTrain(true);
        }
        CustomAbstractMinecartEntity customAbstractMinecartEntity = this;
        if (customAbstractMinecartEntity instanceof CustomMinecartHopperEntity) {
            CustomMinecartHopperEntity hopperMc = (CustomMinecartHopperEntity)customAbstractMinecartEntity;
            hopperMc.getChainInventories();
        } else {
            customAbstractMinecartEntity = this;
            if (customAbstractMinecartEntity instanceof CustomMinecartFurnaceEntity) {
                CustomMinecartFurnaceEntity furnaceMc = (CustomMinecartFurnaceEntity)customAbstractMinecartEntity;
                furnaceMc.numberOfChildren = furnaceMc.getNumberOfChildren();
                furnaceMc.getChainInventories();
            }
        }
    }

    public int getNumberOfChildren() {
        if (this.getLinkedChild() != null) {
            return this.getLinkedChild().getNumberOfChildren() + 1;
        }
        return 0;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            boolean flag;
            if (this.m_6673_(pSource)) {
                return false;
            }
            this.m_38160_(-this.m_38177_());
            this.m_38154_(10);
            this.m_5834_();
            this.m_38109_(this.m_38169_() + pAmount * 10.0f);
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            boolean bl = flag = pSource.m_7639_() instanceof Player && ((Player)pSource.m_7639_()).m_150110_().f_35937_;
            if (this.getLinkedChild() != null) {
                ChainMinecartInterface.unsetParentChild(this, this.getLinkedChild());
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42026_)));
            }
            if (flag || this.m_38169_() > 40.0f) {
                this.m_20153_();
                if (flag && !this.m_8077_()) {
                    this.m_146870_();
                } else {
                    this.m_7617_(pSource);
                }
            }
            return true;
        }
        return true;
    }
}

