/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.entity;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.lordkipama.modernminecarts.entity.CustomAbstractMinecartEntity;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class CustomAbstractMinecartContainerEntity
extends CustomAbstractMinecartEntity
implements ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));

    protected CustomAbstractMinecartContainerEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected CustomAbstractMinecartContainerEntity(EntityType<?> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pLevel, pX, pY, pZ);
    }

    public void m_7617_(DamageSource pSource) {
        super.m_7617_(pSource);
        this.m_219927_(pSource, this.f_19853_, (Entity)this);
    }

    public ItemStack m_8020_(int pIndex) {
        return this.m_219947_(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return this.m_219936_(pIndex, pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return this.m_219945_(pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.m_219940_(pIndex, pStack);
    }

    public SlotAccess m_141942_(int pSlot) {
        return this.m_219951_(pSlot);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player pPlayer) {
        return this.m_219954_(pPlayer);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (!this.f_19853_.f_46443_ && pReason.m_146965_()) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(pReason);
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_219943_(pCompound);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_219934_(pCompound);
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = super.m_6096_(pPlayer, pHand);
        if (ret.m_19077_()) {
            return ret;
        }
        return this.m_219931_((arg_0, arg_1) -> ((CustomAbstractMinecartContainerEntity)this).m_146852_(arg_0, arg_1), pPlayer);
    }

    public InteractionResult m_219931_(BiConsumer<GameEvent, Entity> p_219932_, Player pPlayer) {
        if (!pPlayer.m_6047_()) {
            pPlayer.m_5893_((MenuProvider)this);
            return !pPlayer.f_19853_.f_46443_ ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7114_() {
        float f = 0.98f;
        if (this.lootTable == null) {
            int i = 15 - AbstractContainerMenu.m_38938_((Container)this);
            f += (float)i * 0.001f;
        }
        if (this.m_20069_()) {
            f *= 0.95f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.0, (double)f));
    }

    public void m_6211_() {
        this.m_219953_();
    }

    public void setLootTable(ResourceLocation pLootTable, long pLootTableSeed) {
        this.lootTable = pLootTable;
        this.lootTableSeed = pLootTableSeed;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.lootTable != null && pPlayer.m_5833_()) {
            return null;
        }
        this.m_219949_(pPlayerInventory.f_35978_);
        return this.createMenu(pContainerId, pPlayerInventory);
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation pLootTable) {
        this.lootTable = pLootTable;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long pLootTableSeed) {
        this.lootTableSeed = pLootTableSeed;
    }

    public NonNullList<ItemStack> m_213659_() {
        return this.itemStacks;
    }

    public void m_213775_() {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }
}

