/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.network;

import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.CrystalShulkerBoxTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketTopStackSyncShulkerBox {
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public PacketTopStackSyncShulkerBox(BlockPos pos, NonNullList<ItemStack> topStacks) {
        this.pos = pos;
        this.topStacks = topStacks;
    }

    public static void encode(PacketTopStackSyncShulkerBox msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.pos.m_123341_());
        buf.writeInt(msg.pos.m_123342_());
        buf.writeInt(msg.pos.m_123343_());
        buf.writeInt(msg.topStacks.size());
        for (ItemStack stack : msg.topStacks) {
            buf.m_130055_(stack);
        }
    }

    public static PacketTopStackSyncShulkerBox decode(FriendlyByteBuf buf) {
        BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        NonNullList topStacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buf.m_130267_();
            topStacks.set(item, (Object)itemStack);
        }
        return new PacketTopStackSyncShulkerBox(pos, (NonNullList<ItemStack>)topStacks);
    }

    public static class Handler {
        public static void handle(PacketTopStackSyncShulkerBox message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockEntity tile;
                Level world = (Level)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91073_);
                if (world != null && (tile = world.m_7702_(message.pos)) instanceof CrystalShulkerBoxTileEntity) {
                    ((CrystalShulkerBoxTileEntity)tile).receiveMessageFromServer(message.topStacks);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

