/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.items;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxBlock;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.UpgradableBoxTile;
import ca.lukegrahamlandry.tieredshulkers.common.items.BoxUpgradeType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoxUpgradeItem
extends Item {
    private final BoxUpgradeType type;

    public BoxUpgradeItem(BoxUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (I18n.m_118936_((String)"tieredshulkers.upgrade.tooltip")) {
            String targetName;
            String sourceName = this.type.source == null ? "vanilla" : this.type.source.name;
            String string = targetName = this.type.target == null ? "vanilla" : this.type.target.name;
            if (I18n.m_118936_((String)("tieredshulkers." + sourceName)) && I18n.m_118936_((String)("tieredshulkers." + targetName))) {
                tooltip.add((Component)Component.m_237110_((String)"tieredshulkers.upgrade.tooltip", (Object[])new Object[]{Component.m_237115_((String)("tieredshulkers." + sourceName)).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)("tieredshulkers." + targetName)).m_130940_(ChatFormatting.BOLD)}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
        if (I18n.m_118936_((String)"tieredshulkers.color.tooltip")) {
            tooltip.add((Component)Component.m_237110_((String)"tieredshulkers.color.tooltip", (Object[])new Object[]{0}).m_130940_(ChatFormatting.GOLD));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player entityPlayer = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        Level world = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (this.type.canUpgrade(null)) {
            if (!(world.m_8055_(blockPos).m_60734_() instanceof ShulkerBoxBlock)) {
                return InteractionResult.PASS;
            }
        } else {
            if (!(world.m_8055_(blockPos).m_60734_() instanceof UpgradableBoxBlock)) {
                return InteractionResult.PASS;
            }
            UpgradableBoxBlock block = (UpgradableBoxBlock)world.m_8055_(blockPos).m_60734_();
            if (!block.getTier().equals((Object)this.type.source)) {
                return InteractionResult.PASS;
            }
        }
        BlockEntity tileEntity = world.m_7702_(blockPos);
        UpgradableBoxTile newShulkerBox = null;
        Component customName = null;
        NonNullList shulkerBoxContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        Direction shulkerBoxFacing = Direction.UP;
        ShulkerColour shulkerBoxColor = ShulkerColour.PURPLE;
        if (tileEntity != null) {
            if (tileEntity instanceof UpgradableBoxTile) {
                UpgradableBoxTile shulkerBox = (UpgradableBoxTile)tileEntity;
                BlockState shulkerBoxState = world.m_8055_(blockPos);
                shulkerBoxContents = NonNullList.m_122780_((int)shulkerBox.m_6643_(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < shulkerBoxContents.size(); ++i) {
                    shulkerBoxContents.set(i, (Object)shulkerBox.m_8020_(i));
                }
                shulkerBoxFacing = (Direction)shulkerBoxState.m_61143_((Property)ShulkerBoxBlock.f_56183_);
                customName = shulkerBox.m_7770_();
                shulkerBoxColor = shulkerBox.getColor();
                newShulkerBox = (UpgradableBoxTile)this.type.target.tiles.get((Object)shulkerBoxColor).get().m_155264_(blockPos, this.type.target.blocks.get((Object)shulkerBoxColor).get().m_49966_());
                shulkerBox.m_6211_();
                if (newShulkerBox == null) {
                    return InteractionResult.PASS;
                }
            } else if (tileEntity instanceof ShulkerBoxBlockEntity) {
                BlockState shulkerBoxState = world.m_8055_(blockPos);
                shulkerBoxFacing = (Direction)shulkerBoxState.m_61143_((Property)ShulkerBoxBlock.f_56183_);
                ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)tileEntity;
                if (!this.type.canUpgrade(null)) {
                    return InteractionResult.PASS;
                }
                shulkerBoxContents = NonNullList.m_122780_((int)shulkerBox.m_6643_(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < shulkerBoxContents.size(); ++i) {
                    shulkerBoxContents.set(i, (Object)shulkerBox.m_8020_(i));
                }
                shulkerBoxColor = ShulkerColour.fromVanilla(((ShulkerBoxBlock)world.m_8055_(blockPos).m_60734_()).m_56261_());
                customName = shulkerBox.m_7770_();
                shulkerBox.m_6211_();
                newShulkerBox = (UpgradableBoxTile)this.type.target.tiles.get((Object)shulkerBoxColor).get().m_155264_(blockPos, this.type.target.blocks.get((Object)shulkerBoxColor).get().m_49966_());
            }
        }
        world.m_7471_(blockPos, false);
        world.m_46747_(blockPos);
        BlockState iBlockState = (BlockState)this.type.target.blocks.get((Object)shulkerBoxColor).get().m_49966_().m_61124_((Property)ShulkerBoxBlock.f_56183_, (Comparable)shulkerBoxFacing);
        world.m_7731_(blockPos, iBlockState, 3);
        world.m_7260_(blockPos, iBlockState, iBlockState, 3);
        BlockEntity tileEntity2 = world.m_7702_(blockPos);
        if (tileEntity2 instanceof UpgradableBoxTile) {
            if (customName != null) {
                ((UpgradableBoxTile)tileEntity2).m_58638_(customName);
            }
            ((UpgradableBoxTile)tileEntity2).m_6520_((NonNullList<ItemStack>)shulkerBoxContents);
        }
        if (!entityPlayer.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }
}

