/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.data;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.ShulkerBoxesRegistry;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.items.BoxUpgradeType;
import ca.lukegrahamlandry.tieredshulkers.common.recipes.BoxCraftingRecipeBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BoxesRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final TagKey<Item> SILVER_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/silver"));

    public BoxesRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        for (ShulkerColour dyeColor : ShulkerColour.values()) {
            String color = dyeColor.getName() + "/";
            String group = "tieredshulkers:" + dyeColor.getName() + "_shulker_box";
            this.registerSilverBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.SILVER, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.COPPER, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.IRON, dyeColor), color, group);
            this.registerCopperBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.COPPER, dyeColor), (ItemLike)ShulkerBoxBlock.m_56190_((DyeColor)dyeColor.toVanilla()).m_5456_(), color, group);
            this.registerIronBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.IRON, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.COPPER, dyeColor), (ItemLike)ShulkerBoxBlock.m_56190_((DyeColor)dyeColor.toVanilla()).m_5456_(), color, group);
            this.registerGoldBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.GOLD, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.IRON, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.SILVER, dyeColor), color, group);
            this.registerDiamondBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.DIAMOND, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.GOLD, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.SILVER, dyeColor), color, group);
            this.registerCrystalBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.CRYSTAL, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.DIAMOND, dyeColor), color, group);
            this.registerObsidianBoxRecipe(consumer, (ItemLike)this.getFor(UpgradableBoxTier.OBSIDIAN, dyeColor), (ItemLike)this.getFor(UpgradableBoxTier.DIAMOND, dyeColor), color, group);
        }
        this.addUpgradesRecipes(consumer);
    }

    private Block getFor(UpgradableBoxTier tier, ShulkerColour color) {
        return tier.blocks.get((Object)color).get();
    }

    private void addUpgradesRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "upgrades/";
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.VANILLA_TO_IRON)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42748_).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_iron_ingot", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_IRON)).m_126140_(consumer, BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.VANILLA_TO_IRON)).get(), folder));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.IRON_TO_GOLD)).get())).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).m_126130_("MSM").m_126130_("MMM").m_126130_("MMM").m_126132_("has_iron_ingot", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_IRON)).m_126140_(consumer, BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.IRON_TO_GOLD)).get(), folder));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.GOLD_TO_DIAMOND)).get())).m_206416_(Character.valueOf('M'), Tags.Items.GEMS_DIAMOND).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GMG").m_126130_("GSG").m_126130_("GMG").m_126132_("has_glass", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS)).m_126140_(consumer, BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.GOLD_TO_DIAMOND)).get(), folder));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.DIAMOND_TO_OBSIDIAN)).get())).m_126127_(Character.valueOf('M'), (ItemLike)Blocks.f_50080_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("MGM").m_126130_("MMM").m_126130_("MMM").m_126132_("has_glass", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS)).m_126140_(consumer, BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.DIAMOND_TO_OBSIDIAN)).get(), folder));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.DIAMOND_TO_CRYSTAL)).get())).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50080_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GSG").m_126130_("GGG").m_126130_("GGG").m_126132_("has_glass", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS)).m_126140_(consumer, BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.DIAMOND_TO_CRYSTAL)).get(), folder));
        ResourceLocation woodToCopperChestUpgradeId = BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.VANILLA_TO_COPPER)).get(), folder);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.VANILLA_TO_COPPER)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_COPPER).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42748_).m_126130_("MMM").m_126130_("MSM").m_126130_("MMM").m_126132_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.m_125977_((ItemLike)Items.f_42748_)).m_126140_(consumer, woodToCopperChestUpgradeId);
        ResourceLocation copperToIronChestUpgrade = BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.COPPER_TO_IRON)).get(), folder);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.COPPER_TO_IRON)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GGG").m_126130_("MSM").m_126130_("MGM").m_126132_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)ItemTags.f_13168_)).m_126140_(consumer, copperToIronChestUpgrade);
        ResourceLocation copperToSilverChestUpgrade = BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.COPPER_TO_SILVER)).get(), folder);
        ConditionalRecipe.builder().addCondition(this.and(new ICondition[]{this.not((ICondition)new TagEmptyCondition("forge:ingots/copper")), this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))})).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.COPPER_TO_SILVER)).get())).m_206416_(Character.valueOf('M'), SILVER_TAG).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_COPPER).m_126130_("MSM").m_126130_("MMM").m_126130_("MMM").m_126132_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_COPPER))).m_176498_(arg_0)).setAdvancement(BoxesRecipeProvider.location("recipes/tieredshulkers/upgrades/copper_to_silver_shulker_box_upgrade"), ConditionalAdvancement.builder().addCondition(this.and(new ICondition[]{this.not((ICondition)new TagEmptyCondition("forge:ingots/copper")), this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))})).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)copperToSilverChestUpgrade)).m_138386_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_COPPER)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)copperToSilverChestUpgrade)).m_138360_(RequirementsStrategy.f_15979_))).build(consumer, copperToSilverChestUpgrade);
        ResourceLocation silverToGoldChestUpgrade = BoxesRecipeProvider.prefix((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.SILVER_TO_GOLD)).get(), folder);
        ConditionalRecipe.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)((RegistryObject)ShulkerBoxesRegistry.UPGRADES.get((Object)BoxUpgradeType.SILVER_TO_GOLD)).get())).m_206416_(Character.valueOf('M'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('S'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("MSM").m_126130_("GGG").m_126130_("MGM").m_126132_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS))).m_176498_(arg_0)).setAdvancement(BoxesRecipeProvider.location("recipes/tieredshulkers/upgrades/silver_to_gold_shulker_box_upgrade"), ConditionalAdvancement.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)silverToGoldChestUpgrade)).m_138386_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)silverToGoldChestUpgrade)).m_138360_(RequirementsStrategy.f_15979_))).build(consumer, silverToGoldChestUpgrade);
    }

    protected static ResourceLocation prefix(ItemLike item, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
        return BoxesRecipeProvider.location(prefix + loc.m_135815_());
    }

    private static ResourceLocation location(String id) {
        return new ResourceLocation("tieredshulkers", id);
    }

    private void registerCopperBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        ResourceLocation vanillaToCopperShulkerBox = BoxesRecipeProvider.location("shulkerboxes/" + color + "copper/vanilla_copper_shulker_box");
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.INGOTS_COPPER).key(Character.valueOf('S'), input).patternLine("MMM").patternLine("MSM").patternLine("MMM").addCriterion("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_COPPER)).build(consumer, vanillaToCopperShulkerBox);
    }

    private void registerSilverBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        ResourceLocation copperToSilverShulkerBox = BoxesRecipeProvider.location("shulkerboxes/" + color + "silver/copper_silver_shulker_box");
        ConditionalRecipe.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/copper"))).addRecipe(BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('M'), SILVER_TAG).key(Character.valueOf('S'), input).patternLine("MMM").patternLine("MSM").patternLine("MMM").addCriterion("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has(SILVER_TAG))::build).setAdvancement(BoxesRecipeProvider.location("recipes/tieredshulkers/shulkerboxes/" + color + "silver/copper_silver_shulker_box"), ConditionalAdvancement.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)copperToSilverShulkerBox)).m_138386_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has(SILVER_TAG)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)copperToSilverShulkerBox)).m_138360_(RequirementsStrategy.f_15979_))).build(consumer, copperToSilverShulkerBox);
        ResourceLocation ironToSilverShulkerBox = BoxesRecipeProvider.location("shulkerboxes/" + color + "silver/iron_silver_shulker_box");
        ConditionalRecipe.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/copper"))).addRecipe(BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('M'), SILVER_TAG).key(Character.valueOf('S'), inputTwo).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).patternLine("MGM").patternLine("GSG").patternLine("MGM").addCriterion("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has(SILVER_TAG))::build).setAdvancement(BoxesRecipeProvider.location("recipes/tieredshulkers/shulkerboxes/" + color + "silver/iron_silver_shulker_box"), ConditionalAdvancement.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)ironToSilverShulkerBox)).m_138386_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has(SILVER_TAG)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)ironToSilverShulkerBox)).m_138360_(RequirementsStrategy.f_15979_))).build(consumer, ironToSilverShulkerBox);
    }

    private void registerIronBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).key(Character.valueOf('S'), input).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.INGOTS_IRON).patternLine("MGM").patternLine("GSG").patternLine("MGM").addCriterion("has_gold", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_IRON)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "iron/copper_iron_shulker_box"));
        if (inputTwo == null) {
            return;
        }
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('S'), inputTwo).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.INGOTS_IRON).patternLine("MMM").patternLine("MSM").patternLine("MMM").addCriterion("has_gold", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_GOLD)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "iron/vanilla_iron_shulker_box"));
    }

    private void registerGoldBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('S'), input).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.INGOTS_GOLD).patternLine("MMM").patternLine("MSM").patternLine("MMM").addCriterion("has_gold", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_GOLD)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "gold/iron_gold_shulker_box"));
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).key(Character.valueOf('S'), inputTwo).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.INGOTS_GOLD).patternLine("MGM").patternLine("GSG").patternLine("MGM").addCriterion("has_gold", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.INGOTS_GOLD)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "gold/silver_gold_shulker_box"));
    }

    private void registerDiamondBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, ItemLike inputTwo, String color, String group) {
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).key(Character.valueOf('S'), input).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.GEMS_DIAMOND).patternLine("GGG").patternLine("MSM").patternLine("GGG").addCriterion("has_diamonds", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GEMS_DIAMOND)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "diamond/gold_diamond_shulker_box"));
        ResourceLocation silverToDiamondShulkerBox = BoxesRecipeProvider.location("shulkerboxes/" + color + "diamond/silver_diamond_shulker_box");
        ConditionalRecipe.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addRecipe(BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).key(Character.valueOf('M'), (TagKey<Item>)Tags.Items.GEMS_DIAMOND).key(Character.valueOf('S'), inputTwo).patternLine("GGG").patternLine("GSG").patternLine("MMM").addCriterion("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GEMS_DIAMOND))::build).setAdvancement(BoxesRecipeProvider.location("recipes/tieredshulkers/shulkerboxes/" + color + "diamond/silver_diamond_shulker_box"), ConditionalAdvancement.builder().addCondition(this.not((ICondition)new TagEmptyCondition("forge:ingots/silver"))).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)silverToDiamondShulkerBox)).m_138386_("has_item", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GEMS_DIAMOND)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)silverToDiamondShulkerBox)).m_138360_(RequirementsStrategy.f_15979_))).build(consumer, silverToDiamondShulkerBox);
    }

    private void registerCrystalBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('G'), (TagKey<Item>)Tags.Items.GLASS).key(Character.valueOf('S'), input).patternLine("GGG").patternLine("GSG").patternLine("GGG").addCriterion("has_glass", (CriterionTriggerInstance)BoxesRecipeProvider.has((TagKey<Item>)Tags.Items.GLASS)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "crystal/diamond_crystal_shulker_box"));
    }

    private void registerObsidianBoxRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike input, String color, String group) {
        BoxCraftingRecipeBuilder.shapedRecipe(result).setGroup(group).key(Character.valueOf('M'), (ItemLike)Items.f_41999_).key(Character.valueOf('S'), input).patternLine("MMM").patternLine("MSM").patternLine("MMM").addCriterion("has_obsidian", (CriterionTriggerInstance)BoxesRecipeProvider.m_125977_((ItemLike)Items.f_41999_)).build(consumer, BoxesRecipeProvider.location("shulkerboxes/" + color + "obsidian/diamond_obsidian_shulker_box"));
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> p_206407_) {
        return BoxesRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_()});
    }
}

